/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.cometd.Channel;
import org.cometd.ChannelBayeuxListener;
import org.cometd.ChannelListener;
import org.cometd.Client;
import org.cometd.ConfigurableChannel;
import org.cometd.DataFilter;
import org.cometd.Message;
import org.cometd.SubscriptionListener;
import org.cometd.server.AbstractBayeux;
import org.cometd.server.ChannelId;
import org.cometd.server.ClientImpl;
import org.cometd.server.MessageImpl;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelImpl
implements Channel {
    private final AbstractBayeux _bayeux;
    private final ChannelId _id;
    private final ConcurrentHashMap<String, ChannelImpl> _children = new ConcurrentHashMap();
    private final List<ClientImpl> _subscribers = new CopyOnWriteArrayList<ClientImpl>();
    private final List<DataFilter> _dataFilters = new CopyOnWriteArrayList<DataFilter>();
    private final List<SubscriptionListener> _subscriptionListeners = new CopyOnWriteArrayList<SubscriptionListener>();
    private final CountDownLatch _initialized = new CountDownLatch(1);
    private volatile ChannelImpl _wild;
    private volatile ChannelImpl _wildWild;
    private volatile boolean _persistent;
    private volatile int _split;
    private volatile boolean _lazy;

    protected ChannelImpl(String id, AbstractBayeux bayeux) {
        this._id = new ChannelId(id);
        this._bayeux = bayeux;
    }

    private void waitForInitialized() {
        try {
            if (!this._initialized.await(this._bayeux.getMaxInterval(), TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Not Initialized: " + this);
            }
        }
        catch (InterruptedException x) {
            throw new IllegalStateException("Initialization interrupted: " + this, x);
        }
    }

    private void initialized() {
        this._initialized.countDown();
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    public ChannelImpl addChild(ChannelImpl channel) {
        ChannelId childId = channel.getChannelId();
        if (!this._id.isParentOf(childId)) {
            throw new IllegalArgumentException(this._id + " not parent of " + childId);
        }
        String next = childId.getSegment(this._id.depth());
        if (childId.depth() - this._id.depth() == 1) {
            ChannelImpl old = this._children.putIfAbsent(next, channel);
            if (old != null) {
                old.waitForInitialized();
                return old;
            }
            if ("*".equals(next)) {
                this._wild = channel;
            } else if ("**".equals(next)) {
                this._wildWild = channel;
            }
            this._bayeux.initChannel((ConfigurableChannel)channel);
            channel.initialized();
            this._bayeux.addChannel(channel);
            return channel;
        }
        ChannelImpl branch = (ChannelImpl)this._bayeux.getChannel((this._id.depth() == 0 ? "/" : this._id.toString() + "/") + next, true);
        return branch.addChild(channel);
    }

    public void addDataFilter(DataFilter filter) {
        this._dataFilters.add(filter);
    }

    public ChannelId getChannelId() {
        return this._id;
    }

    public ChannelImpl getChild(ChannelId id) {
        String next = id.getSegment(this._id.depth());
        if (next == null) {
            return null;
        }
        ChannelImpl channel = this._children.get(next);
        if (channel != null) {
            channel.waitForInitialized();
        }
        if (channel == null || channel.getChannelId().depth() == id.depth()) {
            return channel;
        }
        return channel.getChild(id);
    }

    public void getChannels(List<Channel> list) {
        list.add(this);
        for (ChannelImpl channel : this._children.values()) {
            channel.getChannels(list);
        }
    }

    public int getChannelCount() {
        return this._children.size();
    }

    public String getId() {
        return this._id.toString();
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public void deliver(Client from, Iterable<Client> to, Object data, String id) {
        Message m;
        MessageImpl message = this._bayeux.newMessage();
        message.put("channel", (Object)this.getId());
        message.put("data", data);
        if (id != null) {
            message.put("id", (Object)id);
        }
        if ((m = this._bayeux.extendSendBayeux(from, message)) != null) {
            for (Client t : to) {
                this.deliverToSubscriber((ClientImpl)t, from, m);
            }
        }
        if (m instanceof MessageImpl) {
            ((MessageImpl)m).decRef();
        }
    }

    public void publish(Client fromClient, Object data, String msgId) {
        this._bayeux.doPublish(this.getChannelId(), fromClient, data, msgId, false);
    }

    public void publishLazy(Client fromClient, Object data, String msgId) {
        this._bayeux.doPublish(this.getChannelId(), fromClient, data, msgId, true);
    }

    public boolean remove() {
        return this._bayeux.removeChannel(this);
    }

    public boolean doRemove(ChannelImpl channel, List<ChannelBayeuxListener> listeners) {
        String key;
        ChannelImpl child;
        ChannelId channelId = channel.getChannelId();
        int diff = channel._id.depth() - this._id.depth();
        if (diff >= 1 && (child = this._children.get(key = channelId.getSegment(this._id.depth()))) != null) {
            if (diff == 1) {
                if (!child.isPersistent()) {
                    child = this._children.remove(key);
                    if (child != null) {
                        if (this._wild == channel) {
                            this._wild = null;
                        } else if (this._wildWild == channel) {
                            this._wildWild = null;
                        }
                        if (child.getChannelCount() > 0) {
                            for (ChannelImpl c : child._children.values()) {
                                child.doRemove(c, listeners);
                            }
                        }
                        this.notifyChannelRemoved(listeners, child);
                    }
                    return true;
                }
                return false;
            }
            boolean removed = child.doRemove(channel, listeners);
            if (removed && !child.isPersistent() && child.getChannelCount() == 0 && child.getSubscriberCount() == 0 && (child = this._children.remove(key)) != null) {
                this.notifyChannelRemoved(listeners, child);
            }
            return removed;
        }
        return false;
    }

    private void notifyChannelRemoved(List<ChannelBayeuxListener> listeners, ChannelImpl channel) {
        for (ChannelBayeuxListener listener : listeners) {
            try {
                listener.channelRemoved((Channel)channel);
            }
            catch (RuntimeException x) {
                AbstractBayeux.logger.info("Unexpected exception while invoking listener " + listener, (Throwable)x);
            }
        }
    }

    public DataFilter removeDataFilter(DataFilter filter) {
        this._dataFilters.remove(filter);
        return filter;
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    public void subscribe(Client client) {
        if (!(client instanceof ClientImpl)) {
            throw new IllegalArgumentException("Client instance not obtained from Bayeux.newClient()");
        }
        for (ClientImpl c : this._subscribers) {
            if (!client.equals(c)) continue;
            return;
        }
        this._subscribers.add((ClientImpl)client);
        for (SubscriptionListener l : this._subscriptionListeners) {
            l.subscribed(client, (Channel)this);
        }
        ((ClientImpl)client).addSubscription(this);
    }

    public String toString() {
        return this._id.toString();
    }

    public void unsubscribe(Client c) {
        if (!(c instanceof ClientImpl)) {
            throw new IllegalArgumentException("Client instance not obtained from Bayeux.newClient()");
        }
        ClientImpl client = (ClientImpl)c;
        client.removeSubscription(this);
        this._subscribers.remove(client);
        for (SubscriptionListener l : this._subscriptionListeners) {
            l.unsubscribed((Client)client, (Channel)this);
        }
        if (!this._persistent && this._subscribers.size() == 0 && this._children.size() == 0) {
            this.remove();
        }
    }

    protected void doDelivery(ChannelId to, Client from, Message msg) {
        int tail = to.depth() - this._id.depth();
        Object data = msg.getData();
        if (data != null) {
            Object old = data;
            try {
                switch (tail) {
                    case 0: {
                        for (DataFilter filter : this._dataFilters) {
                            data = filter.filter(from, (Channel)this, data);
                            if (data != null) continue;
                            return;
                        }
                        break;
                    }
                    case 1: {
                        ChannelImpl wild = this._wild;
                        if (wild != null) {
                            for (DataFilter filter : wild._dataFilters) {
                                data = filter.filter(from, (Channel)this, data);
                                if (data != null) continue;
                                return;
                            }
                        }
                    }
                    default: {
                        ChannelImpl wildWild = this._wildWild;
                        if (wildWild != null) {
                            for (DataFilter filter : wildWild._dataFilters) {
                                data = filter.filter(from, (Channel)this, data);
                                if (data != null) continue;
                                return;
                            }
                        }
                    }
                }
            }
            catch (IllegalStateException e) {
                Log.ignore((Throwable)e);
                return;
            }
            if (data != old) {
                msg.put((Object)"data", data);
            }
        }
        switch (tail) {
            case 0: {
                int split;
                int i;
                ClientImpl[] subscribers;
                if (this._lazy && msg instanceof MessageImpl) {
                    ((MessageImpl)msg).setLazy(true);
                }
                if ((subscribers = this._subscribers.toArray(new ClientImpl[this._subscribers.size()])).length <= 0) break;
                for (i = split = this._split++ % subscribers.length; i < subscribers.length; ++i) {
                    this.deliverToSubscriber(subscribers[i], from, msg);
                }
                for (i = 0; i < split; ++i) {
                    this.deliverToSubscriber(subscribers[i], from, msg);
                }
                break;
            }
            case 1: {
                ChannelImpl wild = this._wild;
                if (wild != null) {
                    if (wild._lazy && msg instanceof MessageImpl) {
                        ((MessageImpl)msg).setLazy(true);
                    }
                    for (ClientImpl client : wild._subscribers) {
                        wild.deliverToSubscriber(client, from, msg);
                    }
                }
            }
            default: {
                String next;
                ChannelImpl channel;
                ChannelImpl wildWild = this._wildWild;
                if (wildWild != null) {
                    if (wildWild._lazy && msg instanceof MessageImpl) {
                        ((MessageImpl)msg).setLazy(true);
                    }
                    for (ClientImpl client : wildWild._subscribers) {
                        wildWild.deliverToSubscriber(client, from, msg);
                    }
                }
                if ((channel = this._children.get(next = to.getSegment(this._id.depth()))) == null) break;
                channel.doDelivery(to, from, msg);
            }
        }
    }

    private void deliverToSubscriber(ClientImpl subscriber, Client from, Message message) {
        if (this._bayeux.hasClient(subscriber.getId())) {
            subscriber.doDelivery(from, message);
        } else {
            this.unsubscribe(subscriber);
        }
    }

    public Collection<Client> getSubscribers() {
        return new ArrayList<Client>(this._subscribers);
    }

    public int getSubscriberCount() {
        return this._subscribers.size();
    }

    public Collection<DataFilter> getDataFilters() {
        return new ArrayList<DataFilter>(this._dataFilters);
    }

    public void addListener(ChannelListener listener) {
        if (listener instanceof SubscriptionListener) {
            this._subscriptionListeners.add((SubscriptionListener)listener);
        }
    }

    public void removeListener(ChannelListener listener) {
        if (listener instanceof SubscriptionListener) {
            this._subscriptionListeners.remove((SubscriptionListener)listener);
        }
    }
}

