/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.util.log.Log;

public abstract class LongPollingTransport
extends HttpTransport {
    private static final AtomicInteger __zero = new AtomicInteger(0);
    public static final String PREFIX = "long-polling";
    public static final String BROWSER_ID_OPTION = "browserId";
    public static final String MAX_SESSIONS_PER_BROWSER_OPTION = "maxSessionsPerBrowser";
    public static final String MULTI_SESSION_INTERVAL_OPTION = "multiSessionInterval";
    public static final String AUTOBATCH_OPTION = "autoBatch";
    private final ConcurrentHashMap<String, AtomicInteger> _browserMap = new ConcurrentHashMap();
    protected String _browserId = "BAYEUX_BROWSER";
    private int _maxSessionsPerBrowser = 2;
    private long _multiSessionInterval = 2000L;
    private boolean _autoBatch = true;

    protected LongPollingTransport(BayeuxServerImpl bayeux, String name) {
        super(bayeux, name);
        this.setOptionPrefix(PREFIX);
        this.setOption(BROWSER_ID_OPTION, this._browserId);
        this.setOption(MAX_SESSIONS_PER_BROWSER_OPTION, this._maxSessionsPerBrowser);
        this.setOption(MULTI_SESSION_INTERVAL_OPTION, this._multiSessionInterval);
        this.setOption(AUTOBATCH_OPTION, this._autoBatch);
    }

    @Override
    protected void init() {
        super.init();
        this._browserId = this.getOption(BROWSER_ID_OPTION, this._browserId);
        this._maxSessionsPerBrowser = this.getOption(MAX_SESSIONS_PER_BROWSER_OPTION, this._maxSessionsPerBrowser);
        this._multiSessionInterval = this.getOption(MULTI_SESSION_INTERVAL_OPTION, this._multiSessionInterval);
        this._autoBatch = this.getOption(AUTOBATCH_OPTION, this._autoBatch);
    }

    protected String getBrowserId(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._browserId.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        String browser_id = Long.toHexString(request.getRemotePort()) + Long.toString(this.getBayeux().randomLong(), 36) + Long.toString(System.currentTimeMillis(), 36) + Long.toString(request.getRemotePort(), 36);
        Cookie cookie = new Cookie(this._browserId, browser_id);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        response.addCookie(cookie);
        return browser_id;
    }

    protected boolean incBrowserId(String browserId) {
        int sessions;
        AtomicInteger new_count;
        if (this._maxSessionsPerBrowser < 0) {
            return true;
        }
        AtomicInteger count = this._browserMap.get(browserId);
        if (count == null && (count = this._browserMap.putIfAbsent(browserId, new_count = new AtomicInteger())) == null) {
            count = new_count;
        }
        if ((sessions = count.incrementAndGet()) > this._maxSessionsPerBrowser) {
            count.decrementAndGet();
            return false;
        }
        return true;
    }

    protected void decBrowserId(String browserId) {
        AtomicInteger count = this._browserMap.get(browserId);
        if (count != null && count.decrementAndGet() == 0) {
            this._browserMap.remove(browserId, __zero);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LongPollScheduler scheduler = (LongPollScheduler)request.getAttribute("cometd.scheduler");
        if (scheduler == null) {
            boolean batch = false;
            ServerSessionImpl session = null;
            boolean connect = false;
            try {
                ServerMessage.Mutable[] messages = this.parseMessages(request);
                if (messages == null) {
                    return;
                }
                PrintWriter writer = null;
                for (ServerMessage.Mutable message : messages) {
                    connect = "/meta/connect".equals(message.getChannel());
                    if (session == null) {
                        session = (ServerSessionImpl)this.getBayeux().getSession(message.getClientId());
                        if (this._autoBatch && !batch && session != null && !connect) {
                            batch = true;
                            session.startBatch();
                        }
                    }
                    if (connect && session != null) {
                        session.setScheduler(null);
                    }
                    boolean was_connected = session != null && session.isConnected();
                    ServerMessage reply = this.getBayeux().handle(session, message);
                    if (reply != null) {
                        if (session == null) {
                            session = (ServerSessionImpl)this.getBayeux().getSession(reply.getClientId());
                            if (session != null) {
                                session.setUserAgent(request.getHeader("User-Agent"));
                            }
                        } else {
                            if (connect || !this.isMetaConnectDeliveryOnly() && !session.isMetaConnectDeliveryOnly()) {
                                writer = this.sendQueue(request, response, session, writer);
                            }
                            if (connect) {
                                long timeout = session.calculateTimeout(this.getTimeout());
                                if (timeout > 0L && was_connected && writer == null && reply.isSuccessful() && session.isQueueEmpty()) {
                                    String browserId = this.getBrowserId(request, response);
                                    if (this.incBrowserId(browserId)) {
                                        Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                                        continuation.setTimeout(timeout);
                                        continuation.suspend();
                                        scheduler = new LongPollScheduler(session, continuation, reply, browserId);
                                        session.setScheduler(scheduler);
                                        request.setAttribute("cometd.scheduler", (Object)scheduler);
                                        reply = null;
                                    } else {
                                        Map advice = reply.asMutable().getAdvice(true);
                                        advice.put("multiple-clients", true);
                                        if (this._multiSessionInterval > 0L) {
                                            advice.put("reconnect", "retry");
                                            advice.put("interval", this._multiSessionInterval);
                                        } else {
                                            advice.put("reconnect", "none");
                                        }
                                        session.reAdvise();
                                    }
                                } else if (session.isConnected()) {
                                    session.startIntervalTimeout();
                                }
                            }
                        }
                        if (reply != null && (reply = this.getBayeux().extendReply(session, reply)) != null) {
                            writer = this.send(request, response, writer, reply);
                        }
                    }
                    message.setAssociated(null);
                }
                if (writer == null) return;
                this.complete(writer);
                return;
            }
            finally {
                if (batch) {
                    boolean ended = session.endBatch();
                    if (!ended && this.isAlwaysFlushingAfterHandle()) {
                        session.flush();
                    }
                } else if (session != null && !connect && this.isAlwaysFlushingAfterHandle()) {
                    session.flush();
                }
            }
        } else {
            ServerSessionImpl session = scheduler.getSession();
            if (session.isConnected()) {
                session.startIntervalTimeout();
            }
            PrintWriter writer = this.sendQueue(request, response, session, null);
            ServerMessage reply = scheduler.getReply();
            reply = this.getBayeux().extendReply(session, reply);
            writer = this.send(request, response, writer, reply);
            this.complete(writer);
        }
    }

    private PrintWriter sendQueue(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, PrintWriter writer) throws IOException {
        List<ServerMessage> queue = session.takeQueue();
        for (ServerMessage m : queue) {
            writer = this.send(request, response, writer, m);
        }
        return writer;
    }

    protected abstract boolean isAlwaysFlushingAfterHandle();

    protected abstract PrintWriter send(HttpServletRequest var1, HttpServletResponse var2, PrintWriter var3, ServerMessage var4) throws IOException;

    protected abstract void complete(PrintWriter var1) throws IOException;

    private class LongPollScheduler
    implements AbstractServerTransport.OneTimeScheduler,
    ContinuationListener {
        private final ServerSessionImpl _session;
        private final Continuation _continuation;
        private final ServerMessage _reply;
        private String _browserId;

        public LongPollScheduler(ServerSessionImpl session, Continuation continuation, ServerMessage reply, String browserId) {
            this._session = session;
            this._continuation = continuation;
            this._continuation.addContinuationListener((ContinuationListener)this);
            this._reply = reply;
            this._browserId = browserId;
        }

        @Override
        public void cancel() {
            if (this._continuation != null && this._continuation.isSuspended() && !this._continuation.isExpired()) {
                try {
                    this.decBrowserId();
                    ((HttpServletResponse)this._continuation.getServletResponse()).sendError(503);
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
                try {
                    this._continuation.complete();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
            }
        }

        @Override
        public void schedule() {
            this.decBrowserId();
            this._continuation.resume();
        }

        public ServerSessionImpl getSession() {
            return this._session;
        }

        public Continuation getContinuation() {
            return this._continuation;
        }

        public ServerMessage getReply() {
            return this._reply;
        }

        public void onComplete(Continuation continuation) {
            this.decBrowserId();
        }

        public void onTimeout(Continuation continuation) {
            this._session.setScheduler(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decBrowserId() {
            LongPollScheduler longPollScheduler = this;
            synchronized (longPollScheduler) {
                if (this._browserId != null) {
                    LongPollingTransport.this.decBrowserId(this._browserId);
                    this._browserId = null;
                }
            }
        }
    }
}

