/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.Transport;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.common.ChannelId;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.DefaultSecurityPolicy;
import org.cometd.server.LocalSessionImpl;
import org.cometd.server.ServerChannelImpl;
import org.cometd.server.ServerMessageImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.JSONPTransport;
import org.cometd.server.transport.JSONTransport;
import org.cometd.server.transport.WebSocketTransport;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

public class BayeuxServerImpl
extends AbstractLifeCycle
implements BayeuxServer {
    private final Logger _logger;
    private final SecureRandom _random = new SecureRandom();
    private final List<BayeuxServer.BayeuxServerListener> _listeners = new CopyOnWriteArrayList<BayeuxServer.BayeuxServerListener>();
    private final List<BayeuxServer.Extension> _extensions = new CopyOnWriteArrayList<BayeuxServer.Extension>();
    private final ConcurrentMap<String, ServerSessionImpl> _sessions = new ConcurrentHashMap<String, ServerSessionImpl>();
    private final ConcurrentMap<String, ServerChannelImpl> _channels = new ConcurrentHashMap<String, ServerChannelImpl>();
    private final ConcurrentMap<String, Transport> _transports = new ConcurrentHashMap<String, Transport>();
    private final List<String> _allowedTransports = new CopyOnWriteArrayList<String>();
    private final ThreadLocal<AbstractServerTransport> _currentTransport = new ThreadLocal();
    private final Map<String, Object> _options = new TreeMap<String, Object>();
    private final Timeout _timeout = new Timeout();
    private SecurityPolicy _policy = new DefaultSecurityPolicy();
    private Timer _timer = new Timer();
    private Object _handshakeAdvice = new JSON.Literal("{\"reconnect\":\"handshake\",\"interval\":500}");

    public BayeuxServerImpl() {
        this._logger = Log.getLogger((String)("bayeux@" + ((Object)((Object)this)).hashCode()));
        this.createIfAbsent("/meta/handshake", new ConfigurableServerChannel.Initializer[0]);
        this.createIfAbsent("/meta/connect", new ConfigurableServerChannel.Initializer[0]);
        this.createIfAbsent("/meta/subscribe", new ConfigurableServerChannel.Initializer[0]);
        this.createIfAbsent("/meta/unsubscribe", new ConfigurableServerChannel.Initializer[0]);
        this.createIfAbsent("/meta/disconnect", new ConfigurableServerChannel.Initializer[0]);
        ((ServerChannelImpl)this.getChannel("/meta/handshake")).addListener(new HandshakeHandler());
        ((ServerChannelImpl)this.getChannel("/meta/connect")).addListener(new ConnectHandler());
        ((ServerChannelImpl)this.getChannel("/meta/subscribe")).addListener(new SubscribeHandler());
        ((ServerChannelImpl)this.getChannel("/meta/unsubscribe")).addListener(new UnsubscribeHandler());
        ((ServerChannelImpl)this.getChannel("/meta/disconnect")).addListener(new DisconnectHandler());
        this.setOption("tickIntervalMs", "97");
        this.setOption("sweepIntervalMs", "997");
    }

    public BayeuxServerImpl(boolean initializeDefaultTransports) {
        this();
        if (initializeDefaultTransports) {
            this.initializeDefaultTransports();
        }
    }

    public void initializeDefaultTransports() {
        ArrayList<String> allowedTransports = new ArrayList<String>();
        boolean websocketAvailable = this.isWebSocketAvailable();
        if (websocketAvailable) {
            this.addTransport((Transport)new WebSocketTransport(this));
            allowedTransports.add("websocket");
        }
        this.addTransport((Transport)new JSONTransport(this));
        allowedTransports.add("long-polling");
        this.addTransport((Transport)new JSONPTransport(this));
        allowedTransports.add("callback-polling");
        this.setAllowedTransports(allowedTransports);
    }

    private boolean isWebSocketAvailable() {
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.eclipse.jetty.websocket.WebSocket");
            return true;
        }
        catch (ClassNotFoundException x) {
            return false;
        }
    }

    public Logger getLogger() {
        return this._logger;
    }

    protected void doStart() throws Exception {
        long sweep_interval;
        super.doStart();
        this._timer = new Timer("BayeuxServer@" + ((Object)((Object)this)).hashCode(), true);
        long tick_interval = this.getLongOptions("tickIntervalMs", -1L);
        if (tick_interval > 0L) {
            this._timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BayeuxServerImpl.this._timeout.tick(System.currentTimeMillis());
                }
            }, tick_interval, tick_interval);
        }
        if ((sweep_interval = this.getLongOptions("sweepIntervalMs", -1L)) > 0L) {
            this._timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BayeuxServerImpl.this.doSweep();
                    long now = System.currentTimeMillis();
                    for (ServerSessionImpl session : BayeuxServerImpl.this._sessions.values()) {
                        session.sweep(now);
                    }
                }
            }, sweep_interval, sweep_interval);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._timer.cancel();
        this._timer = null;
    }

    public void startTimeout(Timeout.Task task, long interval) {
        this._timeout.schedule(task, interval);
    }

    public void cancelTimeout(Timeout.Task task) {
        task.cancel();
    }

    public ChannelId newChannelId(String id) {
        ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(id);
        if (channel != null) {
            return channel.getChannelId();
        }
        return new ChannelId(id);
    }

    public Map<String, Object> getOptions() {
        return this._options;
    }

    public Object getOption(String qualifiedName) {
        return this._options.get(qualifiedName);
    }

    protected long getLongOptions(String name, long dft) {
        Object val = this.getOption(name);
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val != null) {
            return Long.valueOf(val.toString());
        }
        return dft;
    }

    public Set<String> getOptionNames() {
        return this._options.keySet();
    }

    public void setOption(String qualifiedName, Object value) {
        this._options.put(qualifiedName, value);
    }

    public int randomInt() {
        return this._random.nextInt();
    }

    public int randomInt(int n) {
        return this._random.nextInt(n);
    }

    public long randomLong() {
        return this._random.nextLong();
    }

    public void setCurrentTransport(AbstractServerTransport transport) {
        this._currentTransport.set(transport);
    }

    public ServerTransport getCurrentTransport() {
        return this._currentTransport.get();
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIfAbsent(String channelId, ConfigurableServerChannel.Initializer ... initializers) {
        ServerChannelImpl proposed;
        ServerChannelImpl channel;
        if (this._channels.containsKey(channelId)) {
            return false;
        }
        ChannelId id = new ChannelId(channelId);
        if (id.depth() > 1) {
            this.createIfAbsent(id.getParent(), new ConfigurableServerChannel.Initializer[0]);
        }
        if ((channel = this._channels.putIfAbsent(channelId, proposed = new ServerChannelImpl(this, id))) == null) {
            channel = proposed;
            this._logger.debug("added {}", new Object[]{channel});
            try {
                for (ConfigurableServerChannel.Initializer initializer : initializers) {
                    initializer.configureChannel((ConfigurableServerChannel)channel);
                }
                for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                    if (!(listener instanceof ConfigurableServerChannel.Initializer)) continue;
                    ((ConfigurableServerChannel.Initializer)listener).configureChannel((ConfigurableServerChannel)channel);
                }
            }
            finally {
                channel.initialized();
            }
            for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                if (!(listener instanceof BayeuxServer.ChannelListener)) continue;
                ((BayeuxServer.ChannelListener)listener).channelAdded((ServerChannel)channel);
            }
            return true;
        }
        channel.waitForInitialized();
        return false;
    }

    @Deprecated
    public ServerChannel getChannel(String channelId, boolean create) {
        ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(channelId);
        if (channel == null && create) {
            this.createIfAbsent(channelId, new ConfigurableServerChannel.Initializer[0]);
            channel = (ServerChannelImpl)this._channels.get(channelId);
        }
        return channel;
    }

    public Collection<ServerSessionImpl> getSessions() {
        return Collections.unmodifiableCollection(this._sessions.values());
    }

    public ServerSession getSession(String clientId) {
        if (clientId == null) {
            return null;
        }
        return (ServerSession)this._sessions.get(clientId);
    }

    protected void addServerSession(ServerSessionImpl session) {
        this._sessions.put(session.getId(), session);
        for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
            if (!(listener instanceof BayeuxServer.SessionListener)) continue;
            ((BayeuxServer.SessionListener)listener).sessionAdded((ServerSession)session);
        }
    }

    public boolean removeServerSession(ServerSession session, boolean timedout) {
        ServerSessionImpl removed;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("remove " + session + (timedout ? " timedout" : ""), new Object[0]);
        }
        if ((removed = (ServerSessionImpl)this._sessions.remove(session.getId())) == session) {
            for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                if (!(listener instanceof BayeuxServer.SessionListener)) continue;
                ((BayeuxServer.SessionListener)listener).sessionRemoved(session, timedout);
            }
            return ((ServerSessionImpl)session).removed(timedout);
        }
        return false;
    }

    protected ServerSessionImpl newServerSession() {
        return new ServerSessionImpl(this);
    }

    protected ServerSessionImpl newServerSession(LocalSessionImpl local, String idHint) {
        return new ServerSessionImpl(this, local, idHint);
    }

    public LocalSession newLocalSession(String idHint) {
        return new LocalSessionImpl(this, idHint);
    }

    public ServerMessage.Mutable newMessage() {
        return new ServerMessageImpl().asMutable();
    }

    public ServerMessage.Mutable newMessage(ServerMessage tocopy) {
        ServerMessage.Mutable mutable = new ServerMessageImpl().asMutable();
        for (String key : tocopy.keySet()) {
            mutable.put((Object)key, tocopy.get((Object)key));
        }
        return mutable;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this._policy = securityPolicy;
    }

    public void addExtension(BayeuxServer.Extension extension) {
        this._extensions.add(extension);
    }

    public void removeExtension(BayeuxServer.Extension extension) {
        this._extensions.remove(extension);
    }

    public void addListener(BayeuxServer.BayeuxServerListener listener) {
        if (!(listener instanceof BayeuxServer.BayeuxServerListener)) {
            throw new IllegalArgumentException("!BayeuxServerListener");
        }
        this._listeners.add(listener);
    }

    public ServerChannel getChannel(String channelId) {
        return (ServerChannel)this._channels.get(channelId);
    }

    public List<ServerChannelImpl> getChannelChildren(ChannelId id) {
        ArrayList<ServerChannelImpl> children = new ArrayList<ServerChannelImpl>();
        for (ServerChannelImpl channel : this._channels.values()) {
            if (!id.isParentOf(channel.getChannelId())) continue;
            children.add(channel);
        }
        return children;
    }

    public void removeListener(BayeuxServer.BayeuxServerListener listener) {
        this._listeners.remove(listener);
    }

    public ServerMessage handle(ServerSessionImpl session, ServerMessage.Mutable message) {
        ServerMessage.Mutable reply = null;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(">  " + message + " " + session, new Object[0]);
        }
        if (!this.extendRecv(session, message) || session != null && !session.extendRecv(message)) {
            reply = this.createReply(message);
            reply.setSuccessful(false);
            reply.put((Object)"error", (Object)"404::Message deleted");
        } else {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(">> " + message, new Object[0]);
            }
            String channelId = message.getChannel();
            ServerChannel channel = null;
            if (channelId != null && (channel = this.getChannel(channelId)) == null && this._policy.canCreate((BayeuxServer)this, (ServerSession)session, channelId, (ServerMessage)message)) {
                this.createIfAbsent(channelId, new ConfigurableServerChannel.Initializer[0]);
                channel = this.getChannel(channelId);
            }
            if (channel == null) {
                reply = this.createReply(message);
                this.error(reply, channelId == null ? "402::no channel" : "403::Cannot create");
            } else if (channel.isMeta()) {
                this.doPublish(session, (ServerChannelImpl)channel, message);
                reply = message.getAssociated().asMutable();
            } else if (this._policy.canPublish((BayeuxServer)this, (ServerSession)session, channel, (ServerMessage)message)) {
                if (session != null && session.isLocalSession() || channel.isService()) {
                    message.setClientId(null);
                    channel.publish((Session)session, (ServerMessage)message);
                } else {
                    ServerMessage.Mutable out = this.newMessage();
                    out.setChannel(message.getChannel());
                    out.setData(message.getData());
                    out.setId(message.getId());
                    channel.publish((Session)session, (ServerMessage)out);
                }
                reply = this.createReply(message);
                reply.setSuccessful(true);
            } else {
                reply = this.createReply(message);
                this.error(reply, session == null ? "402::unknown client" : "403::Cannot publish");
            }
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("<< " + reply, new Object[0]);
        }
        return reply;
    }

    protected void doPublish(ServerSessionImpl from, ServerChannelImpl to, ServerMessage.Mutable mutable) {
        ServerChannelImpl channel;
        String parent = to.getChannelId().getParent();
        while (parent != null) {
            ServerChannelImpl c = (ServerChannelImpl)this._channels.get(parent.toString());
            if (c == null) {
                return;
            }
            if (c.isLazy()) {
                mutable.setLazy(true);
            }
            parent = c.getChannelId().getParent();
        }
        List wildIds = to.getChannelId().getWilds();
        ServerChannelImpl[] listening_channels = new ServerChannelImpl[wildIds.size() + 1];
        listening_channels[wildIds.size()] = to;
        int i = wildIds.size();
        while (i-- > 0) {
            listening_channels[i] = (ServerChannelImpl)this._channels.get(wildIds.get(i));
        }
        for (i = 0; i < listening_channels.length; ++i) {
            channel = listening_channels[i];
            if (channel == null) continue;
            if (channel.isLazy()) {
                mutable.setLazy(true);
            }
            for (ServerChannel.ServerChannelListener serverChannelListener : channel.getListeners()) {
                if (!(serverChannelListener instanceof ServerChannel.MessageListener) || ((ServerChannel.MessageListener)serverChannelListener).onMessage((ServerSession)from, (ServerChannel)to, mutable)) continue;
                return;
            }
        }
        for (i = 0; i < listening_channels.length; ++i) {
            channel = listening_channels[i];
            if (channel == null) continue;
            for (ServerSession serverSession : channel.getSubscribers()) {
                ((ServerSessionImpl)serverSession).doDeliver(from, mutable.asImmutable());
            }
        }
        if (to.isMeta()) {
            for (ServerChannel.ServerChannelListener listener : to.getListeners()) {
                if (!(listener instanceof HandlerListener)) continue;
                ((HandlerListener)listener).onMessage(from, mutable);
            }
        }
    }

    public ServerMessage extendReply(ServerSessionImpl session, ServerMessage reply) {
        if (session != null) {
            reply = session.extendSend(reply);
        }
        if (reply != null && !this.extendSend(session, reply.asMutable())) {
            reply = null;
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("<  " + reply, new Object[0]);
        }
        return reply;
    }

    protected boolean extendRecv(ServerSessionImpl from, ServerMessage.Mutable message) {
        if (message.isMeta()) {
            for (BayeuxServer.Extension ext : this._extensions) {
                if (ext.rcvMeta((ServerSession)from, message)) continue;
                return false;
            }
        } else {
            for (BayeuxServer.Extension ext : this._extensions) {
                if (ext.rcv((ServerSession)from, message)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean extendSend(ServerSessionImpl to, ServerMessage.Mutable message) {
        if (message.isMeta()) {
            ListIterator<BayeuxServer.Extension> i = this._extensions.listIterator(this._extensions.size());
            while (i.hasPrevious()) {
                if (i.previous().sendMeta((ServerSession)to, message)) continue;
                return false;
            }
        } else {
            ListIterator<BayeuxServer.Extension> i = this._extensions.listIterator(this._extensions.size());
            while (i.hasPrevious()) {
                if (i.previous().send(message)) continue;
                return false;
            }
        }
        return true;
    }

    boolean removeServerChannel(ServerChannelImpl channel) {
        if (this._channels.remove(channel.getId(), channel)) {
            this._logger.debug("removed {}", new Object[]{channel});
            for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                if (!(listener instanceof BayeuxServer.ChannelListener)) continue;
                ((BayeuxServer.ChannelListener)listener).channelRemoved(channel.getId());
            }
            return true;
        }
        return false;
    }

    List<BayeuxServer.BayeuxServerListener> getListeners() {
        return this._listeners;
    }

    public List<String> getAllowedTransports() {
        return Collections.unmodifiableList(this._allowedTransports);
    }

    public Set<String> getKnownTransportNames() {
        return this._transports.keySet();
    }

    public Transport getTransport(String transport) {
        return (Transport)this._transports.get(transport);
    }

    public void addTransport(Transport transport) {
        this._transports.put(transport.getName(), transport);
    }

    public void setAllowedTransports(String ... allowed) {
        this.setAllowedTransports(Arrays.asList(allowed));
    }

    public void setAllowedTransports(List<String> allowed) {
        this._allowedTransports.clear();
        for (String transport : allowed) {
            if (!this._transports.containsKey(transport)) continue;
            this._allowedTransports.add(transport);
        }
    }

    protected void error(ServerMessage.Mutable reply, String error) {
        reply.put((Object)"error", (Object)error);
        reply.setSuccessful(false);
    }

    protected ServerMessage.Mutable createReply(ServerMessage.Mutable message) {
        ServerMessage.Mutable reply = this.newMessage();
        message.setAssociated((ServerMessage)reply);
        reply.setAssociated((ServerMessage)message);
        reply.setChannel(message.getChannel());
        String id = message.getId();
        if (id != null) {
            reply.setId(id);
        }
        return reply;
    }

    public void doSweep() {
        HashMap<String, Integer> dust = new HashMap<String, Integer>();
        for (Object channel : this._channels.values()) {
            String parent;
            if (!dust.containsKey(((ServerChannelImpl)channel).getId())) {
                dust.put(((ServerChannelImpl)channel).getId(), 0);
            }
            if ((parent = ((ServerChannelImpl)channel).getChannelId().getParent()) == null) continue;
            Integer children = (Integer)dust.get(parent);
            dust.put(parent, children == null ? 1 : children + 1);
        }
        for (Object channel : dust.keySet()) {
            ServerChannelImpl sci = (ServerChannelImpl)this._channels.get(channel);
            if (sci == null) continue;
            sci.doSweep((Integer)dust.get(channel));
        }
    }

    public String dump() {
        StringBuilder b = new StringBuilder();
        ArrayList<ServerChannelImpl> children = new ArrayList<ServerChannelImpl>();
        for (ServerChannelImpl channel : this._channels.values()) {
            if (channel.getChannelId().depth() != 1) continue;
            children.add(channel);
        }
        int leaves = children.size();
        int i = 0;
        for (ServerChannelImpl child : children) {
            b.append(" +-");
            child.dump(b, ++i == leaves ? "   " : " | ");
        }
        return b.toString();
    }

    class DisconnectHandler
    extends HandlerListener {
        DisconnectHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (session == null) {
                BayeuxServerImpl.this.error(reply, "402::Unknown client");
                return;
            }
            BayeuxServerImpl.this.removeServerSession(session, false);
            session.flush();
            reply.setSuccessful(true);
        }
    }

    class UnsubscribeHandler
    extends HandlerListener {
        UnsubscribeHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl from, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (from == null) {
                BayeuxServerImpl.this.error(reply, "402::Unknown client");
                reply.put((Object)"advice", BayeuxServerImpl.this._handshakeAdvice);
                return;
            }
            String subscribe_id = (String)message.get((Object)"subscription");
            reply.put((Object)"subscription", (Object)subscribe_id);
            if (subscribe_id == null) {
                BayeuxServerImpl.this.error(reply, "400::no channel");
            } else {
                reply.put((Object)"subscription", (Object)subscribe_id);
                ServerChannelImpl channel = (ServerChannelImpl)BayeuxServerImpl.this.getChannel(subscribe_id);
                if (channel == null) {
                    BayeuxServerImpl.this.error(reply, "400::no channel");
                } else {
                    if (from.isLocalSession() || !channel.isMeta() && !channel.isService()) {
                        channel.unsubscribe(from);
                    }
                    reply.setSuccessful(true);
                }
            }
        }
    }

    class SubscribeHandler
    extends HandlerListener {
        SubscribeHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl from, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (from == null) {
                BayeuxServerImpl.this.error(reply, "402::Unknown client");
                reply.put((Object)"advice", BayeuxServerImpl.this._handshakeAdvice);
                return;
            }
            String subscribe_id = (String)message.get((Object)"subscription");
            reply.put((Object)"subscription", (Object)subscribe_id);
            if (subscribe_id == null) {
                BayeuxServerImpl.this.error(reply, "403::cannot create");
            } else {
                reply.put((Object)"subscription", (Object)subscribe_id);
                ServerChannelImpl channel = (ServerChannelImpl)BayeuxServerImpl.this.getChannel(subscribe_id);
                if (channel == null && BayeuxServerImpl.this.getSecurityPolicy().canCreate((BayeuxServer)BayeuxServerImpl.this, (ServerSession)from, subscribe_id, (ServerMessage)message)) {
                    BayeuxServerImpl.this.createIfAbsent(subscribe_id, new ConfigurableServerChannel.Initializer[0]);
                    channel = (ServerChannelImpl)BayeuxServerImpl.this.getChannel(subscribe_id);
                }
                if (channel == null) {
                    BayeuxServerImpl.this.error(reply, "403::cannot create");
                } else if (!BayeuxServerImpl.this.getSecurityPolicy().canSubscribe((BayeuxServer)BayeuxServerImpl.this, (ServerSession)from, (ServerChannel)channel, (ServerMessage)message)) {
                    BayeuxServerImpl.this.error(reply, "403::cannot subscribe");
                } else if (from.isLocalSession() || !channel.isMeta() && !channel.isService()) {
                    if (channel.subscribe(from)) {
                        reply.setSuccessful(true);
                    } else {
                        BayeuxServerImpl.this.error(reply, "403::subscribe failed");
                    }
                } else {
                    reply.setSuccessful(true);
                }
            }
        }
    }

    class ConnectHandler
    extends HandlerListener {
        ConnectHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (session == null) {
                BayeuxServerImpl.this.error(reply, "402::Unknown client");
                reply.put((Object)"advice", BayeuxServerImpl.this._handshakeAdvice);
                return;
            }
            session.connect();
            Map adviceIn = message.getAdvice();
            if (adviceIn != null) {
                Long timeout = (Long)adviceIn.get("timeout");
                session.updateTransientTimeout(timeout == null ? -1L : timeout);
                Long interval = (Long)adviceIn.get("interval");
                session.updateTransientInterval(interval == null ? -1L : interval);
                session.reAdvise();
            } else {
                session.updateTransientTimeout(-1L);
                session.updateTransientInterval(-1L);
            }
            Object adviceOut = session.takeAdvice();
            if (adviceOut != null) {
                reply.put((Object)"advice", adviceOut);
            }
            reply.setSuccessful(true);
        }
    }

    class HandshakeHandler
    extends HandlerListener {
        HandshakeHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            if (session == null) {
                session = BayeuxServerImpl.this.newServerSession();
            }
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (BayeuxServerImpl.this._policy != null && !BayeuxServerImpl.this._policy.canHandshake((BayeuxServer)BayeuxServerImpl.this, (ServerSession)session, (ServerMessage)message)) {
                BayeuxServerImpl.this.error(reply, "403::Handshake denied");
                reply.getAdvice(true).put("reconnect", "none");
                return;
            }
            session.handshake();
            BayeuxServerImpl.this.addServerSession(session);
            reply.setSuccessful(true);
            reply.put((Object)"clientId", (Object)session.getId());
            reply.put((Object)"version", (Object)"1.0");
            reply.put((Object)"minimumVersion", (Object)"1.0");
            reply.put((Object)"supportedConnectionTypes", BayeuxServerImpl.this.getAllowedTransports());
        }
    }

    abstract class HandlerListener
    implements ServerChannel.ServerChannelListener {
        HandlerListener() {
        }

        public abstract void onMessage(ServerSessionImpl var1, ServerMessage.Mutable var2);
    }
}

