/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.text.ParseException;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.transport.AbstractStreamHttpTransport;

public class JSONPTransport
extends AbstractStreamHttpTransport {
    public static final String PREFIX = "long-polling.jsonp";
    public static final String NAME = "callback-polling";
    public static final String MIME_TYPE_OPTION = "mimeType";
    public static final String CALLBACK_PARAMETER_OPTION = "callbackParameter";
    public static final String CALLBACK_PARAMETER_MAX_LENGTH_OPTION = "callbackParameterMaxLength";
    private static final Pattern CALLBACK_PATTERN = Pattern.compile("^[a-zA-Z0-9\\._\\-]+$");
    private String _mimeType = "text/javascript;charset=UTF-8";
    private String _callbackParam = "jsonp";
    private int _callbackMaxLength = 50;

    public JSONPTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public void init() {
        super.init();
        this._callbackParam = this.getOption(CALLBACK_PARAMETER_OPTION, this._callbackParam);
        this._callbackMaxLength = this.getOption(CALLBACK_PARAMETER_MAX_LENGTH_OPTION, this._callbackMaxLength);
        this._mimeType = this.getOption(MIME_TYPE_OPTION, this._mimeType);
        this.setMetaConnectDeliveryOnly(true);
    }

    @Override
    public boolean accept(HttpServletRequest request) {
        String callbackValue = request.getParameter(this.getCallbackParameter());
        return "GET".equals(request.getMethod()) && this.isCallbackValueValid(callbackValue);
    }

    @Override
    protected ServerMessage.Mutable[] parseMessages(HttpServletRequest request) throws IOException, ParseException {
        return this.parseMessages(request.getParameterValues("message"));
    }

    public String getCallbackParameter() {
        return this._callbackParam;
    }

    @Override
    protected ServletOutputStream beginWrite(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(this._mimeType);
        String callback = request.getParameter(this._callbackParam);
        ServletOutputStream output = response.getOutputStream();
        output.print(callback);
        output.print("([");
        return output;
    }

    @Override
    protected void endWrite(ServletOutputStream output) throws IOException {
        output.print("])");
        output.close();
    }

    private boolean isCallbackValueValid(String callbackValue) {
        return callbackValue != null && callbackValue.length() <= this._callbackMaxLength && CALLBACK_PATTERN.matcher(callbackValue).matches();
    }
}

