/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.io.EOFException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cometd.javascript.HttpCookieStore;
import org.cometd.javascript.ThreadModel;
import org.cometd.javascript.XMLHttpRequestClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.FutureResponseListener;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLHttpRequestExchange
extends ScriptableObject {
    private CometDExchange exchange;

    public void jsConstructor(Object client, Object cookieStore, Object threadModel, Scriptable thiz, String method, String url, boolean async) {
        this.exchange = new CometDExchange((XMLHttpRequestClient)((Object)client), (HttpCookieStore)((Object)cookieStore), (ThreadModel)threadModel, thiz, method, url, async);
    }

    public String getClassName() {
        return "XMLHttpRequestExchange";
    }

    public boolean isAsynchronous() {
        return this.exchange.isAsynchronous();
    }

    public void await() throws InterruptedException, ExecutionException, TimeoutException {
        this.exchange.get(60L, TimeUnit.SECONDS);
        this.exchange.notifyReadyStateChange(false);
    }

    public void jsFunction_addRequestHeader(String name, String value) {
        this.exchange.getRequest().header(name, value);
    }

    public String jsGet_method() {
        return this.exchange.getRequest().getMethod();
    }

    public void jsFunction_setRequestContent(String data) throws UnsupportedEncodingException {
        this.exchange.setRequestContent(data);
    }

    public int jsGet_readyState() {
        return this.exchange.getReadyState();
    }

    public String jsGet_responseText() {
        return this.exchange.getResponseText();
    }

    public int jsGet_responseStatus() {
        return this.exchange.getResponseStatus();
    }

    public String jsGet_responseStatusText() {
        return this.exchange.getResponseStatusText();
    }

    public void jsFunction_abort() {
        this.exchange.abort();
    }

    public String jsFunction_getAllResponseHeaders() {
        return this.exchange.getAllResponseHeaders();
    }

    public String jsFunction_getResponseHeader(String name) {
        return this.exchange.getResponseHeader(name);
    }

    public void jsFunction_send() throws Exception {
        this.exchange.send();
        try {
            if (!this.isAsynchronous()) {
                this.await();
            }
        }
        catch (InterruptedException x) {
            throw new InterruptedIOException();
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw (Error)cause;
        }
    }

    public static class CometDExchange
    extends FutureResponseListener {
        private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
        private final HttpCookieStore cookieStore;
        private final ThreadModel threads;
        private final Scriptable thiz;
        private final boolean async;
        private volatile boolean aborted;
        private volatile ReadyState readyState = ReadyState.UNSENT;
        private volatile String requestText;
        private volatile String responseText;
        private volatile int responseStatus;
        private volatile String responseStatusText;

        public CometDExchange(XMLHttpRequestClient client, HttpCookieStore cookieStore, ThreadModel threads, Scriptable thiz, String method, String url, boolean async) {
            super(client.getHttpClient().newRequest(url));
            this.getRequest().method(HttpMethod.fromString((String)method));
            this.cookieStore = cookieStore;
            this.threads = threads;
            this.thiz = thiz;
            this.async = async;
            this.aborted = false;
            this.readyState = ReadyState.OPENED;
            this.responseStatusText = null;
            if (async) {
                this.notifyReadyStateChange(false);
            }
        }

        public boolean isAsynchronous() {
            return this.async;
        }

        private void notifyReadyStateChange(boolean sync) {
            this.threads.invoke(sync, this.thiz, this.thiz, "onreadystatechange", new Object[0]);
        }

        private void notifyLoad() {
            this.threads.invoke(false, this.thiz, this.thiz, "onload", new Object[0]);
        }

        private void notifyError() {
            this.threads.invoke(false, this.thiz, this.thiz, "onerror", new Object[0]);
        }

        public void send() throws Exception {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Submitted {}", (Object)this);
            }
            this.getRequest().send((Response.CompleteListener)this);
        }

        public void abort() {
            this.cancel(false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Aborted {}", (Object)this);
            }
            this.aborted = true;
            this.responseText = null;
            this.getRequest().getHeaders().clear();
            if (!this.async || this.readyState == ReadyState.HEADERS_RECEIVED || this.readyState == ReadyState.LOADING) {
                this.readyState = ReadyState.DONE;
                this.notifyReadyStateChange(false);
                this.notifyError();
            }
            this.readyState = ReadyState.UNSENT;
        }

        public int getReadyState() {
            return this.readyState.ordinal();
        }

        public String getResponseText() {
            return this.responseText;
        }

        public int getResponseStatus() {
            return this.responseStatus;
        }

        public String getResponseStatusText() {
            return this.responseStatusText;
        }

        public void setRequestContent(String content) {
            this.requestText = content;
            this.getRequest().content((ContentProvider)new StringContentProvider(content));
        }

        public String getAllResponseHeaders() {
            return this.getRequest().getHeaders().toString();
        }

        public String getResponseHeader(String name) {
            return this.getRequest().getHeaders().getStringField(name);
        }

        public void onBegin(Response response) {
            super.onBegin(response);
            this.responseStatus = response.getStatus();
            this.responseStatusText = response.getReason();
        }

        public void onHeaders(Response response) {
            super.onHeaders(response);
            if (!this.aborted && this.async) {
                this.readyState = ReadyState.HEADERS_RECEIVED;
                this.notifyReadyStateChange(true);
            }
        }

        public void onContent(Response response, ByteBuffer content) {
            super.onContent(response, content);
            if (!this.aborted && this.async && this.readyState != ReadyState.LOADING) {
                this.readyState = ReadyState.LOADING;
                this.notifyReadyStateChange(true);
            }
        }

        public void onComplete(Result result) {
            if (result.isSucceeded()) {
                Response response = result.getResponse();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Succeeded ({}) {}", (Object)response.getStatus(), (Object)this);
                }
                if (!this.aborted) {
                    this.responseText = this.getContentAsString();
                    this.readyState = ReadyState.DONE;
                    if (this.async) {
                        this.notifyReadyStateChange(true);
                        this.notifyLoad();
                    }
                }
            } else {
                Throwable failure = result.getFailure();
                if (!(failure instanceof EOFException) && this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed " + (Object)((Object)this), failure);
                }
                if (this.async) {
                    this.readyState = ReadyState.DONE;
                    this.notifyReadyStateChange(true);
                    this.notifyError();
                }
            }
            super.onComplete(result);
        }

        public String toString() {
            return this.requestText == null ? this.getRequest().toString() : String.format("%s%n%s", this.getRequest(), this.requestText);
        }

        public static enum ReadyState {
            UNSENT,
            OPENED,
            HEADERS_RECEIVED,
            LOADING,
            DONE;

        }
    }
}

