/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;

public class JavaScriptCookieStore {
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US).withZone(ZoneId.of("GMT"));
    private final CookieStore store;

    public JavaScriptCookieStore(CookieStore store) {
        this.store = store;
    }

    public CookieStore getStore() {
        return this.store;
    }

    public String get(String scheme, String host, String path) {
        try {
            URI uri = URI.create(scheme + "://" + host + path);
            List<HttpCookie> uriCookies = this.store.get(uri);
            StringBuilder buffer = new StringBuilder();
            if (uriCookies != null) {
                for (HttpCookie cookie : uriCookies) {
                    if (cookie.isHttpOnly() || cookie.hasExpired()) continue;
                    if (buffer.length() > 0) {
                        buffer.append(";");
                    }
                    buffer.append(cookie.getName()).append("=").append(cookie.getValue());
                }
            }
            return buffer.toString();
        }
        catch (Exception x) {
            x.printStackTrace();
            throw x;
        }
    }

    public void set(String scheme, String host, String uriPath, String cookies) throws Exception {
        block12: {
            try {
                String[] parts;
                String name = null;
                String value = null;
                boolean secure = false;
                boolean httpOnly = false;
                String domain = null;
                String path = null;
                Long maxAge = null;
                for (String part : parts = cookies.split(";")) {
                    if ("Secure".equalsIgnoreCase(part = part.trim())) {
                        secure = true;
                        continue;
                    }
                    if ("HttpOnly".equalsIgnoreCase(part)) {
                        httpOnly = true;
                        continue;
                    }
                    String[] pair = part.split("=", 2);
                    String key = pair[0].trim();
                    String val = pair[1].trim();
                    if ("Domain".equalsIgnoreCase(key)) {
                        domain = val;
                        continue;
                    }
                    if ("Path".equalsIgnoreCase(key)) {
                        path = val;
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase(key)) {
                        if (maxAge != null) continue;
                        Instant parsed = this.formatter.parse((CharSequence)val, Instant::from);
                        maxAge = ChronoUnit.SECONDS.between(parsed, Instant.now());
                        continue;
                    }
                    if ("Max-Age".equalsIgnoreCase(key)) {
                        maxAge = Long.parseLong(val);
                        continue;
                    }
                    if ("Comment".equalsIgnoreCase(key) || "CommentURL".equalsIgnoreCase(key) || "Discard".equalsIgnoreCase(key) || "Port".equalsIgnoreCase(key) || "Version".equalsIgnoreCase(key)) continue;
                    name = key;
                    value = val;
                }
                URI uri = URI.create(scheme + "://" + host + uriPath);
                List<HttpCookie> uriCookies = this.store.get(uri);
                if (value == null || value.isEmpty()) {
                    if (uriCookies == null) break block12;
                    for (HttpCookie cookie : uriCookies) {
                        if (!cookie.getName().equals(name)) continue;
                        this.store.remove(uri, cookie);
                        break block12;
                    }
                    break block12;
                }
                HttpCookie cookie = new HttpCookie(name, value);
                cookie.setSecure(secure);
                cookie.setHttpOnly(httpOnly);
                cookie.setDomain(domain);
                cookie.setPath(path);
                if (maxAge != null) {
                    cookie.setMaxAge(maxAge);
                }
                this.store.add(uri, cookie);
            }
            catch (Exception x) {
                x.printStackTrace();
                throw x;
            }
        }
    }
}

