/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.schema;

import graphql.ExceptionWhileDataFetching;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import org.dotwebstack.graphql.orchestrate.exception.GraphqlJavaOrchestrateException;
import org.dotwebstack.graphql.orchestrate.schema.Executor;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class RemoteExecutor
implements Executor {
    @NonNull
    private final WebClient webClient;
    @NonNull
    private final URI endpoint;

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionInput input) {
        ParameterizedTypeReference<Map<String, Object>> mapTypeRef = new ParameterizedTypeReference<Map<String, Object>>(){};
        Map<String, Map> body = Map.of("query", input.getQuery(), "variables", input.getVariables());
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.endpoint)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue(body)).exchangeToMono(arg_0 -> RemoteExecutor.lambda$execute$0(mapTypeRef, arg_0)).map(RemoteExecutor::mapToResult).toFuture();
    }

    private static ExecutionResult mapToResult(Map<String, Object> body) {
        if (body.containsKey("data")) {
            return ExecutionResultImpl.newExecutionResult().data(body.get("data")).build();
        }
        if (body.containsKey("status") && body.containsKey("detail")) {
            return ExecutionResultImpl.newExecutionResult().addError((GraphQLError)new ExceptionWhileDataFetching(ResultPath.rootPath(), (Throwable)new GraphqlJavaOrchestrateException(HttpStatus.valueOf((int)Integer.parseInt(body.get("status").toString())), body.get("detail").toString()), SourceLocation.EMPTY)).build();
        }
        return ExecutionResultImpl.newExecutionResult().addError((GraphQLError)new ExceptionWhileDataFetching(ResultPath.rootPath(), (Throwable)new GraphqlJavaOrchestrateException(HttpStatus.valueOf((int)500), "Something went wrong while orchestrating the request."), SourceLocation.EMPTY)).build();
    }

    @Generated
    RemoteExecutor(@NonNull WebClient webClient, @NonNull URI endpoint) {
        if (webClient == null) {
            throw new NullPointerException("webClient is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        this.webClient = webClient;
        this.endpoint = endpoint;
    }

    @Generated
    public static RemoteExecutorBuilder newExecutor() {
        return new RemoteExecutorBuilder();
    }

    private static /* synthetic */ Mono lambda$execute$0(1 mapTypeRef, ClientResponse clientResponse) {
        return clientResponse.bodyToMono((ParameterizedTypeReference)mapTypeRef);
    }

    @Generated
    public static class RemoteExecutorBuilder {
        @Generated
        private WebClient webClient;
        @Generated
        private URI endpoint;

        @Generated
        RemoteExecutorBuilder() {
        }

        @Generated
        public RemoteExecutorBuilder webClient(@NonNull WebClient webClient) {
            if (webClient == null) {
                throw new NullPointerException("webClient is marked non-null but is null");
            }
            this.webClient = webClient;
            return this;
        }

        @Generated
        public RemoteExecutorBuilder endpoint(@NonNull URI endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint is marked non-null but is null");
            }
            this.endpoint = endpoint;
            return this;
        }

        @Generated
        public RemoteExecutor build() {
            return new RemoteExecutor(this.webClient, this.endpoint);
        }

        @Generated
        public String toString() {
            return "RemoteExecutor.RemoteExecutorBuilder(webClient=" + this.webClient + ", endpoint=" + this.endpoint + ")";
        }
    }
}

