/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.schema;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.dotwebstack.graphql.orchestrate.schema.Executor;
import org.dotwebstack.graphql.orchestrate.transform.Transform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subschema {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(Subschema.class);
    @NonNull
    private final GraphQLSchema schema;
    private final Executor executor;
    private final Transform transform;

    public CompletableFuture<ExecutionResult> execute(ExecutionInput input) {
        LOG.debug("Executing query:\n{}", (Object)input.getQuery());
        if (this.executor != null) {
            return this.executor.execute(input);
        }
        GraphQL graphql = GraphQL.newGraphQL((GraphQLSchema)this.schema).build();
        return graphql.executeAsync(input);
    }

    public Subschema transform(@NonNull Consumer<SubschemaBuilder> builderConsumer) {
        if (builderConsumer == null) {
            throw new NullPointerException("builderConsumer is marked non-null but is null");
        }
        SubschemaBuilder builder = this.toBuilder();
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Generated
    Subschema(@NonNull GraphQLSchema schema, Executor executor, Transform transform) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        this.schema = schema;
        this.executor = executor;
        this.transform = transform;
    }

    @Generated
    public static SubschemaBuilder newSubschema() {
        return new SubschemaBuilder();
    }

    @Generated
    public SubschemaBuilder toBuilder() {
        return new SubschemaBuilder().schema(this.schema).executor(this.executor).transform(this.transform);
    }

    @NonNull
    @Generated
    public GraphQLSchema getSchema() {
        return this.schema;
    }

    @Generated
    public Executor getExecutor() {
        return this.executor;
    }

    @Generated
    public Transform getTransform() {
        return this.transform;
    }

    @Generated
    public static class SubschemaBuilder {
        @Generated
        private GraphQLSchema schema;
        @Generated
        private Executor executor;
        @Generated
        private Transform transform;

        @Generated
        SubschemaBuilder() {
        }

        @Generated
        public SubschemaBuilder schema(@NonNull GraphQLSchema schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            this.schema = schema;
            return this;
        }

        @Generated
        public SubschemaBuilder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Generated
        public SubschemaBuilder transform(Transform transform) {
            this.transform = transform;
            return this;
        }

        @Generated
        public Subschema build() {
            return new Subschema(this.schema, this.executor, this.transform);
        }

        @Generated
        public String toString() {
            return "Subschema.SubschemaBuilder(schema=" + this.schema + ", executor=" + this.executor + ", transform=" + this.transform + ")";
        }
    }
}

