/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.transform;

import graphql.schema.GraphQLSchema;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import lombok.NonNull;
import org.dotwebstack.graphql.orchestrate.Request;
import org.dotwebstack.graphql.orchestrate.Result;
import org.dotwebstack.graphql.orchestrate.transform.Transform;
import org.dotwebstack.graphql.orchestrate.transform.TransformContext;

public abstract class AbstractTransform
implements Transform {
    @Override
    public Transform pipe(final @NonNull Transform nextTransform) {
        if (nextTransform == null) {
            throw new NullPointerException("nextTransform is marked non-null but is null");
        }
        final AbstractTransform outerTransform = this;
        return new AbstractTransform(){

            @Override
            public GraphQLSchema transformSchema(GraphQLSchema originalSchema, TransformContext context) {
                return nextTransform.transformSchema(outerTransform.transformSchema(originalSchema, context), context);
            }

            @Override
            public CompletableFuture<Result> transform(Request originalRequest, Function<Request, CompletableFuture<Result>> next) {
                return nextTransform.transform(originalRequest, transformedRequest -> outerTransform.transform((Request)transformedRequest, next));
            }
        };
    }

    @Override
    public GraphQLSchema transformSchema(@NonNull GraphQLSchema originalSchema, @NonNull TransformContext context) {
        if (originalSchema == null) {
            throw new NullPointerException("originalSchema is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return originalSchema;
    }

    @Override
    public CompletableFuture<Result> transform(@NonNull Request originalRequest, @NonNull Function<Request, CompletableFuture<Result>> next) {
        if (originalRequest == null) {
            throw new NullPointerException("originalRequest is marked non-null but is null");
        }
        if (next == null) {
            throw new NullPointerException("next is marked non-null but is null");
        }
        return next.apply(originalRequest);
    }
}

