/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.transform;

import graphql.language.Field;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.dotwebstack.graphql.orchestrate.Request;
import org.dotwebstack.graphql.orchestrate.Result;
import org.dotwebstack.graphql.orchestrate.transform.AbstractTransform;
import org.dotwebstack.graphql.orchestrate.transform.ObjectFieldRenamer;
import org.dotwebstack.graphql.orchestrate.transform.RequestMapping;
import org.dotwebstack.graphql.orchestrate.transform.SchemaMapping;
import org.dotwebstack.graphql.orchestrate.transform.TransformContext;
import org.dotwebstack.graphql.orchestrate.transform.TransformUtils;

public class RenameObjectFields
extends AbstractTransform {
    private final ObjectFieldRenamer renamer;
    private final Map<String, Map<String, String>> nameMapping = new HashMap<String, Map<String, String>>();
    private GraphQLSchema transformedSchema;

    public RenameObjectFields(@NonNull ObjectFieldRenamer renamer) {
        if (renamer == null) {
            throw new NullPointerException("renamer is marked non-null but is null");
        }
        this.renamer = renamer;
    }

    @Override
    public GraphQLSchema transformSchema(@NonNull GraphQLSchema originalSchema, @NonNull TransformContext context) {
        if (originalSchema == null) {
            throw new NullPointerException("originalSchema is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.transformedSchema = TransformUtils.mapSchema(originalSchema, SchemaMapping.newSchemaMapping().objectType((objectType, traverserContext) -> {
            List fieldDefinitions = objectType.getFieldDefinitions().stream().map(fieldDefinition -> this.transformField((GraphQLObjectType)objectType, (GraphQLFieldDefinition)fieldDefinition)).collect(Collectors.toList());
            return TreeTransformerUtil.changeNode((TraverserContext)traverserContext, (Object)objectType.transform(builder -> builder.replaceFields(fieldDefinitions)));
        }).build());
        return this.transformedSchema;
    }

    @Override
    public CompletableFuture<Result> transform(@NonNull Request originalRequest, @NonNull Function<Request, CompletableFuture<Result>> next) {
        if (originalRequest == null) {
            throw new NullPointerException("originalRequest is marked non-null but is null");
        }
        if (next == null) {
            throw new NullPointerException("next is marked non-null but is null");
        }
        Request transformedRequest = TransformUtils.mapRequest(originalRequest, this.transformedSchema, RequestMapping.newRequestMapping().field(environment -> {
            Field field = environment.getField();
            GraphQLFieldsContainer fieldsContainer = environment.getFieldsContainer();
            return this.findMappedName(fieldsContainer, field).map(fieldName -> TreeTransformerUtil.changeNode((TraverserContext)environment.getTraverserContext(), (Object)field.transform(builder -> builder.name(fieldName).alias(field.getName())))).orElse(TraversalControl.CONTINUE);
        }).build());
        return next.apply(transformedRequest);
    }

    private Optional<String> findMappedName(GraphQLFieldsContainer fieldsContainer, Field field) {
        return Optional.ofNullable(this.nameMapping.get(fieldsContainer.getName())).flatMap(typeMapping -> Optional.ofNullable((String)typeMapping.get(field.getName())));
    }

    private GraphQLFieldDefinition transformField(GraphQLObjectType objectType, GraphQLFieldDefinition fieldDefinition) {
        String newName = this.renamer.apply(objectType.getName(), fieldDefinition.getName(), fieldDefinition);
        if (newName.equals(fieldDefinition.getName())) {
            return fieldDefinition;
        }
        this.nameMapping.putIfAbsent(objectType.getName(), new HashMap());
        this.nameMapping.get(objectType.getName()).put(newName, fieldDefinition.getName());
        return fieldDefinition.transform(builder -> builder.name(newName));
    }
}

