/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.transform;

import graphql.language.Field;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.dotwebstack.graphql.orchestrate.Request;
import org.dotwebstack.graphql.orchestrate.Result;
import org.dotwebstack.graphql.orchestrate.transform.AbstractTransform;
import org.dotwebstack.graphql.orchestrate.transform.RequestMapping;
import org.dotwebstack.graphql.orchestrate.transform.SchemaMapping;
import org.dotwebstack.graphql.orchestrate.transform.TransformContext;
import org.dotwebstack.graphql.orchestrate.transform.TransformUtils;
import org.dotwebstack.graphql.orchestrate.transform.TypeRenamer;

public class RenameTypes
extends AbstractTransform {
    private final TypeRenamer renamer;
    private final Map<String, String> nameMapping = new HashMap<String, String>();
    private GraphQLSchema originalSchema;

    public RenameTypes(@NonNull TypeRenamer renamer) {
        if (renamer == null) {
            throw new NullPointerException("renamer is marked non-null but is null");
        }
        this.renamer = renamer;
    }

    @Override
    public GraphQLSchema transformSchema(@NonNull GraphQLSchema originalSchema, @NonNull TransformContext context) {
        if (originalSchema == null) {
            throw new NullPointerException("originalSchema is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.originalSchema = originalSchema;
        return TransformUtils.mapSchema(originalSchema, SchemaMapping.newSchemaMapping().objectType((objectType, traverserContext) -> TreeTransformerUtil.changeNode((TraverserContext)traverserContext, (Object)objectType.transform(builder -> builder.name(this.renameType((GraphQLNamedType)objectType))))).interfaceType((interfaceType, traverserContext) -> TreeTransformerUtil.changeNode((TraverserContext)traverserContext, (Object)interfaceType.transform(builder -> builder.name(this.renameType((GraphQLNamedType)interfaceType))))).build());
    }

    @Override
    public CompletableFuture<Result> transform(@NonNull Request originalRequest, @NonNull Function<Request, CompletableFuture<Result>> next) {
        if (originalRequest == null) {
            throw new NullPointerException("originalRequest is marked non-null but is null");
        }
        if (next == null) {
            throw new NullPointerException("next is marked non-null but is null");
        }
        Request transformedRequest = TransformUtils.mapRequest(originalRequest, this.originalSchema, RequestMapping.newRequestMapping().field(environment -> {
            Field field = environment.getField();
            GraphQLOutputType fieldType = environment.getFieldDefinition().getType();
            if (fieldType instanceof GraphQLFieldsContainer) {
                SelectionSet newSelectionSet = this.transformSelectionSet(field.getSelectionSet());
                return TreeTransformerUtil.changeNode((TraverserContext)environment.getTraverserContext(), (Object)field.transform(builder -> builder.selectionSet(newSelectionSet)));
            }
            return TraversalControl.CONTINUE;
        }).build());
        return next.apply(transformedRequest);
    }

    private String renameType(GraphQLNamedType type) {
        String newName = this.renamer.apply(type.getName(), type);
        if (newName.equals(type.getName())) {
            return type.getName();
        }
        this.nameMapping.put(newName, type.getName());
        return newName;
    }

    private SelectionSet transformSelectionSet(SelectionSet selectionSet) {
        List newSelections = selectionSet.getSelections().stream().map(this::transformSelection).collect(Collectors.toList());
        return selectionSet.transform(builder -> builder.selections((Collection)newSelections));
    }

    private Selection<?> transformSelection(Selection<?> selection) {
        if (selection instanceof InlineFragment) {
            return this.transformInlineFragment((InlineFragment)selection);
        }
        return selection;
    }

    private InlineFragment transformInlineFragment(InlineFragment inlineFragment) {
        String typeName = inlineFragment.getTypeCondition().getName();
        if (!this.nameMapping.containsKey(typeName)) {
            return inlineFragment;
        }
        return inlineFragment.transform(builder -> builder.typeCondition(TypeName.newTypeName((String)this.nameMapping.get(typeName)).build()));
    }
}

