/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.wrap;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLSchema;
import lombok.NonNull;
import org.dotwebstack.graphql.orchestrate.delegate.SimpleDelegator;
import org.dotwebstack.graphql.orchestrate.schema.Subschema;
import org.dotwebstack.graphql.orchestrate.transform.TransformContext;

public class SchemaWrapper {
    private SchemaWrapper() {
    }

    public static GraphQLSchema wrap(@NonNull Subschema subschema) {
        if (subschema == null) {
            throw new NullPointerException("subschema is marked non-null but is null");
        }
        GraphQLSchema originalSchema = subschema.getSchema();
        GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry();
        originalSchema.getQueryType().getFieldDefinitions().forEach(fieldDefinition -> codeRegistryBuilder.dataFetcher(originalSchema.getQueryType(), fieldDefinition, SchemaWrapper.createDataFetcher(subschema, fieldDefinition)));
        TransformContext transformContext = TransformContext.newContext().subschema(subschema).build();
        GraphQLSchema wrappedSchema = originalSchema.transform(builder -> builder.codeRegistry(codeRegistryBuilder.build()));
        if (subschema.getTransform() != null) {
            wrappedSchema = subschema.getTransform().transformSchema(wrappedSchema, transformContext);
        }
        return wrappedSchema;
    }

    private static DataFetcher<Object> createDataFetcher(Subschema subschema, GraphQLFieldDefinition fieldDefinition) {
        SimpleDelegator delegator = SimpleDelegator.newDelegator().subschema(subschema).fieldName(fieldDefinition.getName()).argsFromEnv(environment -> environment.getField().getArguments()).build();
        return delegator::delegate;
    }
}

