/*
 * Decompiled with CFR 0.152.
 */
package org.ehoffman.testing.module.webdriver;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.ehoffman.module.ModuleProvider;
import org.ehoffman.module.PooledModule;
import org.ehoffman.testing.module.webdriver.RemoteWebDriverInterface;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class WebDriverGridModule
implements ModuleProvider<RemoteWebDriverInterface> {
    private static final String webDriverSystemPropertyForGridUrl = "webdriver.remote.server";
    private static URL GRID_LOCATION;

    protected WebDriver getRemoteWithVersion(DesiredCapabilities dc, String version) {
        if (version != null && !"".equals(version)) {
            dc.setVersion(version);
        }
        RemoteWebDriver driver = new RemoteWebDriver(GRID_LOCATION, (Capabilities)dc);
        driver = new Augmenter().augment((WebDriver)driver);
        return driver;
    }

    public WebDriver getDriver() throws Exception {
        throw new RuntimeException("Must use a subclass of this class");
    }

    public Object makeObject() throws Exception {
        return this.getDriver();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Class<? extends RemoteWebDriverInterface> getTargetClass() {
        return RemoteWebDriverInterface.class;
    }

    public Map<String, Class<?>> getDependencyDefinition() {
        return null;
    }

    public RemoteWebDriverInterface create(Map<String, ?> dependencies) {
        return null;
    }

    public void destroy() {
    }

    public String getModuleType() {
        return RemoteWebDriverInterface.class.getSimpleName();
    }

    public void destroyObject(Object obj) throws Exception {
    }

    public boolean validateObject(Object obj) {
        return false;
    }

    public void activateObject(Object obj) throws Exception {
    }

    public void passivateObject(Object obj) throws Exception {
        WebDriver driver = (WebDriver)obj;
        driver.quit();
    }

    public int getMaxPoolElements() {
        return 5;
    }

    static {
        try {
            GRID_LOCATION = new URL(System.getProperty(webDriverSystemPropertyForGridUrl));
            System.out.println("grid location: " + GRID_LOCATION.toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static class IPhone
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            DesiredCapabilities dc = DesiredCapabilities.iphone();
            return this.getRemoteWithVersion(dc, null);
        }
    }

    public static class Android
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            DesiredCapabilities dc = DesiredCapabilities.android();
            dc.setPlatform(Platform.LINUX);
            return this.getRemoteWithVersion(dc, null);
        }
    }

    public static class HtmlUnitIE
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            DesiredCapabilities dc = DesiredCapabilities.htmlUnit();
            dc.setBrowserName("internet explorer");
            dc.setJavascriptEnabled(true);
            return this.getRemoteWithVersion(dc, null);
        }
    }

    public static class HtmlUnitFirefox
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            DesiredCapabilities dc = DesiredCapabilities.htmlUnit();
            dc.setBrowserName("firefox");
            dc.setJavascriptEnabled(true);
            return this.getRemoteWithVersion(dc, null);
        }
    }

    public static class Firefox8
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            return this.getRemoteWithVersion(DesiredCapabilities.firefox(), "8");
        }
    }

    public static class Firefox7
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            return this.getRemoteWithVersion(DesiredCapabilities.firefox(), "7");
        }
    }

    public static class Firefox6
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            return this.getRemoteWithVersion(DesiredCapabilities.firefox(), "6");
        }
    }

    public static class Firefox36
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            return this.getRemoteWithVersion(DesiredCapabilities.firefox(), "3.6");
        }
    }

    public static class Firefox
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            return this.getRemoteWithVersion(DesiredCapabilities.firefox(), null);
        }
    }

    public static class Chrome
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            DesiredCapabilities dc = DesiredCapabilities.chrome();
            dc.setCapability("chrome.switches", Arrays.asList("--disable-popup-blocking"));
            return this.getRemoteWithVersion(dc, null);
        }
    }

    public static class IE9
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            return this.getRemoteWithVersion(DesiredCapabilities.internetExplorer(), "9");
        }
    }

    public static class IE8
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            return this.getRemoteWithVersion(DesiredCapabilities.internetExplorer(), "8");
        }
    }

    public static class IE7
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            return this.getRemoteWithVersion(DesiredCapabilities.internetExplorer(), "7");
        }
    }

    public static class IE6
    extends WebDriverGridModule
    implements PooledModule<RemoteWebDriverInterface> {
        @Override
        public WebDriver getDriver() throws Exception {
            return this.getRemoteWithVersion(DesiredCapabilities.internetExplorer(), "6");
        }
    }
}

