/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.script;

import javax.inject.Named;
import org.datacleaner.api.Alias;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.StringProperty;
import org.datacleaner.api.Transformer;
import org.datacleaner.beans.script.JavaScriptUtils;
import org.datacleaner.components.categories.ScriptingCategory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="JavaScript transformer (simple)")
@Alias(value={"JavaScript transformer"})
@Description(value="Supply your own piece of JavaScript to do a custom transformation")
@Categorized(value={ScriptingCategory.class})
public class JavaScriptTransformer
implements Transformer {
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptTransformer.class);
    @Configured
    InputColumn<?>[] columns;
    @Configured
    ReturnType returnType = ReturnType.STRING;
    @Configured
    @Description(value="Available variables:\nvalues[0..]: Array of values\nvalues[\"my_col\"]: Map of values\nmy_col: Each column value has it's own variable\nout: Print to console using out.println('hello')\nlog: Print to log using log.info(...), log.warn(...), log.error(...)")
    @StringProperty(multiline=true, mimeType={"text/javascript", "application/x-javascript"})
    String sourceCode = "function eval() {\n\treturn \"hello \" + values[0];\n}\n\neval();";
    private ContextFactory _contextFactory;
    private Script _script;
    private ScriptableObject _sharedScope;

    public OutputColumns getOutputColumns() {
        OutputColumns outputColumns = new OutputColumns(Object.class, "JavaScript output", new String[0]);
        if (this.returnType == ReturnType.NUMBER) {
            outputColumns.setColumnType(0, Number.class);
        } else if (this.returnType == ReturnType.BOOLEAN) {
            outputColumns.setColumnType(0, Boolean.class);
        } else {
            outputColumns.setColumnType(0, String.class);
        }
        return outputColumns;
    }

    @Initialize
    public void init() {
        this._contextFactory = new ContextFactory();
        Context context = this._contextFactory.enterContext();
        try {
            this._script = context.compileString(this.sourceCode, this.getClass().getSimpleName(), 1, null);
            this._sharedScope = context.initStandardObjects();
            JavaScriptUtils.addToScope((Scriptable)this._sharedScope, logger, "logger", "log");
            JavaScriptUtils.addToScope((Scriptable)this._sharedScope, System.out, "out");
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] transform(InputRow inputRow) {
        Context context = this._contextFactory.enterContext();
        try {
            Scriptable scope = context.newObject((Scriptable)this._sharedScope);
            scope.setPrototype((Scriptable)this._sharedScope);
            scope.setParentScope(null);
            JavaScriptUtils.addToScope(scope, inputRow, this.columns, "values");
            Object result = this._script.exec(context, scope);
            result = result == null ? null : (this.returnType == ReturnType.NUMBER ? Double.valueOf(Context.toNumber((Object)result)) : (this.returnType == ReturnType.BOOLEAN ? Boolean.valueOf(Context.toBoolean((Object)result)) : Context.toString((Object)result)));
            Object[] objectArray = new Object[]{result};
            return objectArray;
        }
        finally {
            Context.exit();
        }
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public void setColumns(InputColumn<?>[] columns) {
        this.columns = columns;
    }

    public static enum ReturnType {
        STRING,
        NUMBER,
        BOOLEAN;

    }
}

