/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.internal;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import org.evomaster.clientJava.clientUtil.SimpleLogger;
import org.evomaster.clientJava.controller.SutHandler;
import org.evomaster.clientJava.controller.internal.EMController;
import org.evomaster.clientJava.controllerApi.dto.AuthenticationDto;
import org.evomaster.clientJava.instrumentation.TargetInfo;
import shaded.org.eclipse.jetty.server.AbstractNetworkConnector;
import shaded.org.eclipse.jetty.server.Server;
import shaded.org.eclipse.jetty.server.handler.ErrorHandler;
import shaded.org.eclipse.jetty.servlet.ServletContextHandler;
import shaded.org.eclipse.jetty.servlet.ServletHolder;
import shaded.org.glassfish.jersey.jackson.JacksonFeature;
import shaded.org.glassfish.jersey.logging.LoggingFeature;
import shaded.org.glassfish.jersey.server.ResourceConfig;
import shaded.org.glassfish.jersey.servlet.ServletContainer;

public abstract class SutController
implements SutHandler {
    private int controllerPort = 40100;
    private String controllerHost = "localhost";
    private Server controllerServer;

    public final boolean startTheControllerServer() {
        ResourceConfig config = new ResourceConfig();
        config.register((Class)JacksonFeature.class);
        config.register(new EMController(this));
        config.register((Class)LoggingFeature.class);
        this.controllerServer = new Server(InetSocketAddress.createUnresolved(this.getControllerHost(), this.getControllerPort()));
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        this.controllerServer.setErrorHandler(errorHandler);
        ServletHolder servlet = new ServletHolder(new ServletContainer(config));
        ServletContextHandler context = new ServletContextHandler(this.controllerServer, "/controller/api/*");
        context.addServlet(servlet, "/*");
        try {
            this.controllerServer.start();
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to start Jetty: " + e.getMessage());
            this.controllerServer.destroy();
        }
        this.newSearch();
        SimpleLogger.info("Started controller server on: " + this.controllerServer.getURI());
        return true;
    }

    public final boolean stopTheControllerServer() {
        try {
            this.controllerServer.stop();
            return true;
        }
        catch (Exception e) {
            SimpleLogger.error(e.toString());
            return false;
        }
    }

    public final int getControllerServerPort() {
        return ((AbstractNetworkConnector)this.controllerServer.getConnectors()[0]).getLocalPort();
    }

    public final int getControllerPort() {
        return this.controllerPort;
    }

    public final void setControllerPort(int controllerPort) {
        this.controllerPort = controllerPort;
    }

    public final String getControllerHost() {
        return this.controllerHost;
    }

    public final void setControllerHost(String controllerHost) {
        this.controllerHost = controllerHost;
    }

    public abstract void newSearch();

    public abstract void newTest();

    public abstract boolean isInstrumentationActivated();

    public abstract boolean isSutRunning();

    public abstract String getPackagePrefixesToCover();

    public abstract String getUrlOfSwaggerJSON();

    public abstract List<AuthenticationDto> getInfoForAuthentication();

    public abstract List<TargetInfo> getTargetInfos(Collection<Integer> var1);
}

