/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.ea.agentloader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import shaded.com.ea.agentloader.ClassPathUtils;

public class AgentLoader {
    private static volatile AgentLoaderInterface agentLoader;

    public static void loadAgent(String agentJar, String options) {
        AgentLoaderInterface agentLoader = AgentLoader.getAgentLoader(agentJar);
        agentLoader.loadAgent(agentJar, options);
    }

    public static void loadAgentClass(String agentClassName, String options) {
        AgentLoader.loadAgentClass(agentClassName, options, null, true, true, false);
    }

    public static void loadAgentClass(String agentClass, String options, String bootClassPath, boolean canRedefineClasses, boolean canRetransformClasses, boolean canSetNativeMethodPrefix) {
        File jarFile;
        try {
            jarFile = AgentLoader.createTemporaryAgentJar(agentClass, bootClassPath, canRedefineClasses, canRetransformClasses, canSetNativeMethodPrefix);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't write jar file for agent:" + agentClass, ex);
        }
        AgentLoader.loadAgent(jarFile.getPath(), options);
    }

    private static synchronized AgentLoaderInterface getAgentLoader(String agentJar) {
        Class<?> agentLoaderClass;
        if (agentLoader != null) {
            return agentLoader;
        }
        try {
            Class.forName("shaded.com.sun.tools.attach.VirtualMachine");
            agentLoaderClass = Class.forName("shaded.com.ea.agentloader.AgentLoaderHotSpot");
        }
        catch (Exception ex) {
            List<String> shaded = Arrays.asList("shaded/AttachProvider.class", "shaded/VirtualMachine.class", "AttachProviderPlaceHolder.class", "shaded/AgentInitializationException.class", "shaded/AgentLoadException.class", "shaded/AttachNotSupportedException.class", "shaded/AttachOperationFailedException.class", "shaded/AttachPermission.class", "shaded/HotSpotAttachProvider.class", "shaded/HotSpotVirtualMachine.class", "shaded/VirtualMachineDescriptor.class", "shaded/WindowsAttachProvider.class", "shaded/WindowsVirtualMachine.class", "shaded/SolarisAttachProvider.class", "shaded/SolarisVirtualMachine.class", "shaded/LinuxAttachProvider.class", "shaded/LinuxVirtualMachine.class", "shaded/BsdAttachProvider.class", "shaded/BsdVirtualMachine.class", "shaded/HotSpotAttachProvider$HotSpotVirtualMachineDescriptor.class", "shaded/BsdVirtualMachine$SocketInputStream.class", "shaded/LinuxVirtualMachine$SocketInputStream.class", "shaded/SolarisVirtualMachine$SocketInputStream.class", "shaded/WindowsVirtualMachine$PipedInputStream.class");
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            ArrayList classes = new ArrayList();
            for (String s : shaded) {
                try {
                    classes.add(ClassPathUtils.defineClass(systemLoader, AgentLoader.class.getResourceAsStream(s)));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error defining: " + s, e);
                }
            }
            try {
                agentLoaderClass = ClassPathUtils.defineClass(systemLoader, AgentLoader.class.getResourceAsStream("/shaded/com/ea/agentloader/AgentLoaderHotSpot.class"));
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading AgentLoader implementation", e);
            }
        }
        try {
            final Object agentLoaderObject = agentLoaderClass.newInstance();
            agentLoader = new AgentLoaderInterface(){

                @Override
                public void loadAgent(String agentJar, String options) {
                    try {
                        Method loadAgentMethod = agentLoaderObject.getClass().getMethod("loadAgent", String.class, String.class);
                        loadAgentMethod.invoke(agentLoaderObject, agentJar, options);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting agent loader implementation to load: " + agentJar, e);
        }
        return agentLoader;
    }

    public static String getPid() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }

    public static File createTemporaryAgentJar(String agentClass, String bootClassPath, boolean canRedefineClasses, boolean canRetransformClasses, boolean canSetNativeMethodPrefix) throws IOException {
        File jarFile = File.createTempFile("javaagent." + agentClass, ".jar");
        jarFile.deleteOnExit();
        AgentLoader.createAgentJar(new FileOutputStream(jarFile), agentClass, bootClassPath, canRedefineClasses, canRetransformClasses, canSetNativeMethodPrefix);
        return jarFile;
    }

    public static void createAgentJar(OutputStream out, String agentClass, String bootClassPath, boolean canRedefineClasses, boolean canRetransformClasses, boolean canSetNativeMethodPrefix) throws IOException {
        Manifest man = new Manifest();
        man.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        man.getMainAttributes().putValue("Agent-Class", agentClass);
        if (bootClassPath != null) {
            man.getMainAttributes().putValue("Boot-Class-Path", bootClassPath);
        }
        man.getMainAttributes().putValue("Can-Redefine-Classes", Boolean.toString(canRedefineClasses));
        man.getMainAttributes().putValue("Can-Retransform-Classes", Boolean.toString(canRetransformClasses));
        man.getMainAttributes().putValue("Can-Set-Native-Method-Prefix", Boolean.toString(canSetNativeMethodPrefix));
        JarOutputStream jarOut = new JarOutputStream(out, man);
        jarOut.flush();
        jarOut.close();
    }

    static interface AgentLoaderInterface {
        public void loadAgent(String var1, String var2);
    }
}

