/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.ea.agentloader;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.util.Locale;
import shaded.com.ea.agentloader.AttachProviderPlaceHolder;
import shaded.com.sun.tools.attach.VirtualMachine;
import shaded.com.sun.tools.attach.spi.AttachProvider;

public class AgentLoaderHotSpot {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAgent(String agentJar, String options) {
        VirtualMachine vm = AgentLoaderHotSpot.getVirtualMachine();
        if (vm == null) {
            throw new RuntimeException("Can't attach to this jvm. Add -javaagent:" + agentJar + " to the commandline");
        }
        try {
            try {
                vm.loadAgent(agentJar, options);
            }
            finally {
                vm.detach();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't attach to this jvm. Add -javaagent:" + agentJar + " to the commandline", e);
        }
    }

    public static VirtualMachine getVirtualMachine() {
        if (VirtualMachine.list().size() > 0) {
            String pid = AgentLoaderHotSpot.getPid();
            try {
                return VirtualMachine.attach((String)pid);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String jvm = System.getProperty("java.vm.name").toLowerCase(Locale.ENGLISH);
        if (jvm.contains("hotspot") || jvm.contains("openjdk")) {
            Class<VirtualMachine> virtualMachineClass = AgentLoaderHotSpot.pickVmImplementation();
            try {
                AttachProviderPlaceHolder attachProvider = new AttachProviderPlaceHolder();
                Constructor<VirtualMachine> vmConstructor = virtualMachineClass.getDeclaredConstructor(AttachProvider.class, String.class);
                vmConstructor.setAccessible(true);
                VirtualMachine newVM = vmConstructor.newInstance(new Object[]{attachProvider, AgentLoaderHotSpot.getPid()});
                return newVM;
            }
            catch (UnsatisfiedLinkError e) {
                throw new RuntimeException("This jre doesn't support the native library for attaching to the jvm", e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String getPid() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }

    private static Class<VirtualMachine> pickVmImplementation() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        try {
            if (os.contains("win")) {
                return AgentLoaderHotSpot.class.getClassLoader().loadClass("sun.tools.attach.WindowsVirtualMachine");
            }
            if (os.contains("nix") || os.contains("nux") || os.indexOf("aix") > 0) {
                return AgentLoaderHotSpot.class.getClassLoader().loadClass("sun.tools.attach.LinuxVirtualMachine");
            }
            if (os.contains("mac")) {
                return AgentLoaderHotSpot.class.getClassLoader().loadClass("sun.tools.attach.BsdVirtualMachine");
            }
            if (os.contains("sunos") || os.contains("solaris")) {
                return AgentLoaderHotSpot.class.getClassLoader().loadClass("sun.tools.attach.SolarisVirtualMachine");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        throw new RuntimeException("Can't find a vm implementation for the operational system: " + System.getProperty("os.name"));
    }
}

