/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.sun.tools.attach;

import jdk.Exported;
import shaded.com.sun.tools.attach.spi.AttachProvider;

@Exported
public class VirtualMachineDescriptor {
    private AttachProvider provider;
    private String id;
    private String displayName;
    private volatile int hash;

    public VirtualMachineDescriptor(AttachProvider attachProvider, String string, String string2) {
        if (attachProvider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("identifier cannot be null");
        }
        if (string2 == null) {
            throw new NullPointerException("display name cannot be null");
        }
        this.provider = attachProvider;
        this.id = string;
        this.displayName = string2;
    }

    public VirtualMachineDescriptor(AttachProvider attachProvider, String string) {
        this(attachProvider, string, string);
    }

    public AttachProvider provider() {
        return this.provider;
    }

    public String id() {
        return this.id;
    }

    public String displayName() {
        return this.displayName;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.provider.hashCode() * 127 + this.id.hashCode();
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VirtualMachineDescriptor)) {
            return false;
        }
        VirtualMachineDescriptor virtualMachineDescriptor = (VirtualMachineDescriptor)object;
        if (virtualMachineDescriptor.provider() != this.provider()) {
            return false;
        }
        return virtualMachineDescriptor.id().equals(this.id());
    }

    public String toString() {
        String string = this.provider.toString() + ": " + this.id;
        if (this.displayName != this.id) {
            string = string + " " + this.displayName;
        }
        return string;
    }
}

