/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.message.filtering;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import shaded.javax.ws.rs.core.Configuration;
import shaded.jersey.repackaged.com.google.common.collect.Lists;
import shaded.jersey.repackaged.com.google.common.collect.Sets;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.jersey.internal.inject.Providers;
import shaded.org.glassfish.jersey.message.filtering.internal.LocalizationMessages;
import shaded.org.glassfish.jersey.message.filtering.spi.FilteringHelper;
import shaded.org.glassfish.jersey.message.filtering.spi.ScopeProvider;
import shaded.org.glassfish.jersey.message.filtering.spi.ScopeResolver;
import shaded.org.glassfish.jersey.model.internal.RankedComparator;

@Singleton
class CommonScopeProvider
implements ScopeProvider {
    private static final Logger LOGGER = Logger.getLogger(CommonScopeProvider.class.getName());
    private final List<ScopeResolver> resolvers;
    private final Configuration config;

    @Inject
    public CommonScopeProvider(Configuration config, ServiceLocator serviceLocator) {
        this.config = config;
        this.resolvers = Lists.newArrayList(Providers.getAllProviders(serviceLocator, ScopeResolver.class, new RankedComparator()));
    }

    @Override
    public Set<String> getFilteringScopes(Annotation[] entityAnnotations, boolean defaultIfNotFound) {
        HashSet<String> filteringScopes = Sets.newHashSet();
        filteringScopes.addAll(this.getFilteringScopes(entityAnnotations));
        if (filteringScopes.isEmpty()) {
            filteringScopes.addAll(this.getFilteringScopes(this.config));
        }
        return this.returnFilteringScopes(filteringScopes, defaultIfNotFound);
    }

    protected Set<String> returnFilteringScopes(Set<String> filteringScopes, boolean returnDefaultFallback) {
        return returnDefaultFallback && filteringScopes.isEmpty() ? FilteringHelper.getDefaultFilteringScope() : filteringScopes;
    }

    protected Set<String> getFilteringScopes(Annotation[] annotations) {
        HashSet<String> filteringScopes = Sets.newHashSet();
        for (ScopeResolver provider : this.resolvers) {
            this.mergeFilteringScopes(filteringScopes, provider.resolve(annotations));
        }
        return filteringScopes;
    }

    private Set<String> getFilteringScopes(Configuration config) {
        Object property = config.getProperty("shaded.jersey.config.entityFiltering.scope");
        Set<String> filteringScopes = Collections.emptySet();
        if (property != null) {
            if (property instanceof Annotation) {
                filteringScopes = this.getFilteringScopes(new Annotation[]{(Annotation)property});
            } else if (property instanceof Annotation[]) {
                filteringScopes = this.getFilteringScopes((Annotation[])property);
            } else {
                LOGGER.log(Level.CONFIG, LocalizationMessages.ENTITY_FILTERING_SCOPE_NOT_ANNOTATIONS(property));
            }
        }
        return filteringScopes;
    }

    protected void mergeFilteringScopes(Set<String> filteringScopes, Set<String> resolvedScopes) {
        if (!filteringScopes.isEmpty() && !resolvedScopes.isEmpty()) {
            LOGGER.log(Level.FINE, LocalizationMessages.MERGING_FILTERING_SCOPES());
        }
        filteringScopes.addAll(resolvedScopes);
    }
}

