/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.model.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import javax.validation.ValidationException;
import shaded.javax.ws.rs.ProcessingException;
import shaded.javax.ws.rs.WebApplicationException;
import shaded.javax.ws.rs.core.Response;
import shaded.javax.ws.rs.core.SecurityContext;
import shaded.org.glassfish.jersey.message.internal.TracingLogger;
import shaded.org.glassfish.jersey.server.ContainerRequest;
import shaded.org.glassfish.jersey.server.SubjectSecurityContext;
import shaded.org.glassfish.jersey.server.internal.LocalizationMessages;
import shaded.org.glassfish.jersey.server.internal.ServerTraceEvent;
import shaded.org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import shaded.org.glassfish.jersey.server.internal.process.MappableException;
import shaded.org.glassfish.jersey.server.model.Invocable;
import shaded.org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;

abstract class AbstractJavaResourceMethodDispatcher
implements ResourceMethodDispatcher {
    private final Method method;
    private final InvocationHandler methodHandler;
    private final Invocable resourceMethod;
    private final ConfiguredValidator validator;

    AbstractJavaResourceMethodDispatcher(Invocable resourceMethod, InvocationHandler methodHandler, ConfiguredValidator validator) {
        this.method = resourceMethod.getDefinitionMethod();
        this.methodHandler = methodHandler;
        this.resourceMethod = resourceMethod;
        this.validator = validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Response dispatch(Object resource, ContainerRequest request) throws ProcessingException {
        Response response = null;
        try {
            response = this.doDispatch(resource, request);
        }
        catch (Throwable throwable) {
            TracingLogger.getInstance(request).log(ServerTraceEvent.DISPATCH_RESPONSE, response);
            throw throwable;
        }
        TracingLogger.getInstance(request).log(ServerTraceEvent.DISPATCH_RESPONSE, response);
        return response;
    }

    protected abstract Response doDispatch(Object var1, ContainerRequest var2) throws ProcessingException;

    final Object invoke(final ContainerRequest containerRequest, final Object resource, final Object ... args) throws ProcessingException {
        try {
            Object invocationResult;
            if (this.validator != null) {
                this.validator.validateResourceAndInputParams(resource, this.resourceMethod, args);
            }
            PrivilegedAction invokeMethodAction = new PrivilegedAction(){

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() {
                    Object object;
                    TracingLogger tracingLogger = TracingLogger.getInstance(containerRequest);
                    long timestamp = tracingLogger.timestamp(ServerTraceEvent.METHOD_INVOKE);
                    try {
                        object = AbstractJavaResourceMethodDispatcher.this.methodHandler.invoke(resource, AbstractJavaResourceMethodDispatcher.this.method, args);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | UndeclaredThrowableException ex) {
                        try {
                            throw new ProcessingException(LocalizationMessages.ERROR_RESOURCE_JAVA_METHOD_INVOCATION(), ex);
                            catch (InvocationTargetException ex2) {
                                throw AbstractJavaResourceMethodDispatcher.mapTargetToRuntimeEx(ex2.getCause());
                            }
                            catch (Throwable t) {
                                throw new ProcessingException(t);
                            }
                        }
                        catch (Throwable throwable) {
                            tracingLogger.logDuration(ServerTraceEvent.METHOD_INVOKE, timestamp, resource, AbstractJavaResourceMethodDispatcher.this.method);
                            throw throwable;
                        }
                    }
                    tracingLogger.logDuration(ServerTraceEvent.METHOD_INVOKE, timestamp, resource, AbstractJavaResourceMethodDispatcher.this.method);
                    return object;
                }
            };
            SecurityContext securityContext = containerRequest.getSecurityContext();
            Object object = invocationResult = securityContext instanceof SubjectSecurityContext ? ((SubjectSecurityContext)securityContext).doAsSubject(invokeMethodAction) : invokeMethodAction.run();
            if (this.validator != null) {
                this.validator.validateResult(resource, this.resourceMethod, invocationResult);
            }
            return invocationResult;
        }
        catch (ValidationException ex) {
            throw new MappableException(ex);
        }
    }

    private static RuntimeException mapTargetToRuntimeEx(Throwable throwable) {
        if (throwable instanceof WebApplicationException) {
            return (WebApplicationException)throwable;
        }
        return new MappableException(throwable);
    }

    public String toString() {
        return this.method.toString();
    }
}

