/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.wadl.internal.generators.resourcedoc;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import javax.xml.parsers.SAXParserFactory;
import shaded.com.sun.research.ws.wadl.Application;
import shaded.com.sun.research.ws.wadl.Doc;
import shaded.com.sun.research.ws.wadl.Method;
import shaded.com.sun.research.ws.wadl.Param;
import shaded.com.sun.research.ws.wadl.ParamStyle;
import shaded.com.sun.research.ws.wadl.Representation;
import shaded.com.sun.research.ws.wadl.Request;
import shaded.com.sun.research.ws.wadl.Resources;
import shaded.com.sun.research.ws.wadl.Response;
import shaded.javax.ws.rs.core.Context;
import shaded.javax.ws.rs.core.MediaType;
import shaded.org.glassfish.jersey.server.model.Parameter;
import shaded.org.glassfish.jersey.server.model.Resource;
import shaded.org.glassfish.jersey.server.model.ResourceMethod;
import shaded.org.glassfish.jersey.server.wadl.WadlGenerator;
import shaded.org.glassfish.jersey.server.wadl.internal.ApplicationDescription;
import shaded.org.glassfish.jersey.server.wadl.internal.WadlUtils;
import shaded.org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.ResourceDocAccessor;
import shaded.org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ClassDocType;
import shaded.org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.MethodDocType;
import shaded.org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ParamDocType;
import shaded.org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.RepresentationDocType;
import shaded.org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ResourceDocType;
import shaded.org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ResponseDocType;
import shaded.org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.WadlParamType;
import shaded.org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.xhtml.Elements;

public class WadlGeneratorResourceDocSupport
implements WadlGenerator {
    private WadlGenerator delegate;
    private File resourceDocFile;
    private InputStream resourceDocStream;
    private ResourceDocAccessor resourceDoc;
    @Context
    private Provider<SAXParserFactory> saxFactoryProvider;

    public WadlGeneratorResourceDocSupport() {
    }

    public WadlGeneratorResourceDocSupport(WadlGenerator wadlGenerator, ResourceDocType resourceDoc) {
        this.delegate = wadlGenerator;
        this.resourceDoc = new ResourceDocAccessor(resourceDoc);
    }

    @Override
    public void setWadlGeneratorDelegate(WadlGenerator delegate) {
        this.delegate = delegate;
    }

    public void setResourceDocFile(File resourceDocFile) {
        if (this.resourceDocStream != null) {
            throw new IllegalStateException("The resourceDocStream property is already set, therefore you cannot set the resourceDocFile property. Only one of both can be set at a time.");
        }
        this.resourceDocFile = resourceDocFile;
    }

    public void setResourceDocStream(InputStream resourceDocStream) {
        if (this.resourceDocStream != null) {
            throw new IllegalStateException("The resourceDocFile property is already set, therefore you cannot set the resourceDocStream property. Only one of both can be set at a time.");
        }
        this.resourceDocStream = resourceDocStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Exception {
        if (this.resourceDocFile == null && this.resourceDocStream == null) {
            throw new IllegalStateException("Neither the resourceDocFile nor the resourceDocStream is set, one of both is required.");
        }
        this.delegate.init();
        try (InputStream inputStream = this.resourceDocFile != null ? new FileInputStream(this.resourceDocFile) : this.resourceDocStream;){
            ResourceDocType resourceDocType = WadlUtils.unmarshall(inputStream, this.saxFactoryProvider.get(), ResourceDocType.class);
            this.resourceDoc = new ResourceDocAccessor(resourceDocType);
        }
        finally {
            this.resourceDocFile = null;
        }
    }

    @Override
    public String getRequiredJaxbContextPath() {
        String name = Elements.class.getName();
        name = name.substring(0, name.lastIndexOf(46));
        return this.delegate.getRequiredJaxbContextPath() == null ? name : this.delegate.getRequiredJaxbContextPath() + ":" + name;
    }

    @Override
    public Application createApplication() {
        return this.delegate.createApplication();
    }

    @Override
    public shaded.com.sun.research.ws.wadl.Resource createResource(Resource r, String path) {
        shaded.com.sun.research.ws.wadl.Resource result = this.delegate.createResource(r, path);
        for (Class<?> resourceClass : r.getHandlerClasses()) {
            ClassDocType classDoc = this.resourceDoc.getClassDoc(resourceClass);
            if (classDoc == null || this.isEmpty(classDoc.getCommentText())) continue;
            Doc doc = new Doc();
            doc.getContent().add(classDoc.getCommentText());
            result.getDoc().add(doc);
        }
        return result;
    }

    @Override
    public Method createMethod(Resource resource, ResourceMethod resourceMethod) {
        Method result = this.delegate.createMethod(resource, resourceMethod);
        java.lang.reflect.Method method = resourceMethod.getInvocable().getDefinitionMethod();
        MethodDocType methodDoc = this.resourceDoc.getMethodDoc(method.getDeclaringClass(), method);
        if (methodDoc != null && !this.isEmpty(methodDoc.getCommentText())) {
            Doc doc = new Doc();
            doc.getContent().add(methodDoc.getCommentText());
            result.getDoc().add(doc);
        }
        return result;
    }

    @Override
    public Representation createRequestRepresentation(Resource r, ResourceMethod m, MediaType mediaType) {
        Representation result = this.delegate.createRequestRepresentation(r, m, mediaType);
        RepresentationDocType requestRepresentation = this.resourceDoc.getRequestRepresentation(m.getInvocable().getDefinitionMethod().getDeclaringClass(), m.getInvocable().getDefinitionMethod(), result.getMediaType());
        if (requestRepresentation != null) {
            result.setElement(requestRepresentation.getElement());
            this.addDocForExample(result.getDoc(), requestRepresentation.getExample());
        }
        return result;
    }

    @Override
    public Request createRequest(Resource r, ResourceMethod m) {
        return this.delegate.createRequest(r, m);
    }

    @Override
    public List<Response> createResponses(Resource r, ResourceMethod m) {
        ResponseDocType responseDoc = this.resourceDoc.getResponse(m.getInvocable().getDefinitionMethod().getDeclaringClass(), m.getInvocable().getDefinitionMethod());
        ArrayList<Response> responses = new ArrayList();
        if (responseDoc != null && responseDoc.hasRepresentations()) {
            for (RepresentationDocType representationDoc : responseDoc.getRepresentations()) {
                Response response = new Response();
                Representation wadlRepresentation = new Representation();
                wadlRepresentation.setElement(representationDoc.getElement());
                wadlRepresentation.setMediaType(representationDoc.getMediaType());
                this.addDocForExample(wadlRepresentation.getDoc(), representationDoc.getExample());
                this.addDoc(wadlRepresentation.getDoc(), representationDoc.getDoc());
                response.getStatus().add(representationDoc.getStatus());
                response.getRepresentation().add(wadlRepresentation);
                responses.add(response);
            }
            if (!responseDoc.getWadlParams().isEmpty()) {
                for (WadlParamType wadlParamType : responseDoc.getWadlParams()) {
                    Param param = new Param();
                    param.setName(wadlParamType.getName());
                    param.setStyle(ParamStyle.fromValue(wadlParamType.getStyle()));
                    param.setType(wadlParamType.getType());
                    this.addDoc(param.getDoc(), wadlParamType.getDoc());
                    for (Response response : responses) {
                        response.getParam().add(param);
                    }
                }
            }
            if (!this.isEmpty(responseDoc.getReturnDoc())) {
                for (Response response : responses) {
                    this.addDoc(response.getDoc(), responseDoc.getReturnDoc());
                }
            }
        } else {
            responses = this.delegate.createResponses(r, m);
        }
        return responses;
    }

    private void addDocForExample(List<Doc> docs, String example) {
        if (!this.isEmpty(example)) {
            Doc doc = new Doc();
            Elements pElement = Elements.el("p").add(Elements.val("h6", "Example")).add(new Object[]{Elements.el("pre").add(Elements.val("code", example))});
            doc.getContent().add((Object)pElement);
            docs.add(doc);
        }
    }

    private void addDoc(List<Doc> docs, String text) {
        if (!this.isEmpty(text)) {
            Doc doc = new Doc();
            doc.getContent().add(text);
            docs.add(doc);
        }
    }

    @Override
    public Param createParam(Resource r, ResourceMethod m, Parameter p) {
        ParamDocType paramDoc;
        Param result = this.delegate.createParam(r, m, p);
        if (result != null && (paramDoc = this.resourceDoc.getParamDoc(m.getInvocable().getDefinitionMethod().getDeclaringClass(), m.getInvocable().getDefinitionMethod(), p)) != null && !this.isEmpty(paramDoc.getCommentText())) {
            Doc doc = new Doc();
            doc.getContent().add(paramDoc.getCommentText());
            result.getDoc().add(doc);
        }
        return result;
    }

    @Override
    public Resources createResources() {
        return this.delegate.createResources();
    }

    private boolean isEmpty(String text) {
        return text == null || text.isEmpty() || "".equals(text.trim());
    }

    @Override
    public WadlGenerator.ExternalGrammarDefinition createExternalGrammar() {
        return this.delegate.createExternalGrammar();
    }

    @Override
    public void attachTypes(ApplicationDescription egd) {
        this.delegate.attachTypes(egd);
    }
}

