/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.common.Loggable;
import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.spy.P6SpyOptions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PreparedStatementInformation
extends StatementInformation
implements Loggable {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Map<Integer, Object> parameterValues = new HashMap<Integer, Object>();

    public PreparedStatementInformation(ConnectionInformation connectionInformation, String query) {
        super(connectionInformation);
        this.setStatementQuery(query);
    }

    @Override
    public String getSqlWithValues() {
        StringBuilder sb = new StringBuilder();
        String statementQuery = this.getStatementQuery();
        int currentParameter = 0;
        for (int pos = 0; pos < statementQuery.length(); ++pos) {
            char character = statementQuery.charAt(pos);
            if (statementQuery.charAt(pos) == '?' && currentParameter <= this.parameterValues.size()) {
                sb.append(this.convertToString(this.parameterValues.get(currentParameter)));
                ++currentParameter;
                continue;
            }
            sb.append(character);
        }
        return sb.toString();
    }

    public void setParameterValue(int position, Object value) {
        this.parameterValues.put(position - 1, value);
    }

    protected Map<Integer, Object> getParameterValues() {
        return this.parameterValues;
    }

    protected String convertToString(Object value) {
        String result;
        if (value == null) {
            result = "NULL";
        } else {
            result = value instanceof Date ? new SimpleDateFormat(P6SpyOptions.getActiveInstance().getDatabaseDialectDateFormat()).format(value) : (value instanceof byte[] ? this.toHexString((byte[])value) : value.toString());
            result = this.quoteIfNeeded(result, value);
        }
        return result;
    }

    private String quoteIfNeeded(String stringValue, Object obj) {
        if (stringValue == null) {
            return null;
        }
        if (Number.class.isAssignableFrom(obj.getClass()) || Boolean.class.isAssignableFrom(obj.getClass())) {
            return stringValue;
        }
        return "'" + this.escape(stringValue) + "'";
    }

    private String escape(String stringValue) {
        return stringValue.replaceAll("'", "''");
    }

    private String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            int temp = b & 0xFF;
            sb.append(HEX_CHARS[temp / 16]);
            sb.append(HEX_CHARS[temp % 16]);
        }
        return sb.toString();
    }
}

