/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.internal;

import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Singleton;
import shaded.javax.ws.rs.InternalServerErrorException;
import shaded.javax.ws.rs.WebApplicationException;
import shaded.javax.ws.rs.ext.ReaderInterceptor;
import shaded.javax.ws.rs.ext.ReaderInterceptorContext;
import shaded.javax.ws.rs.ext.WriterInterceptor;
import shaded.javax.ws.rs.ext.WriterInterceptorContext;
import shaded.org.glassfish.hk2.utilities.binding.AbstractBinder;
import shaded.org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import shaded.org.glassfish.jersey.server.internal.process.MappableException;

@Priority(value=10)
@Singleton
public class MappableExceptionWrapperInterceptor
implements ReaderInterceptor,
WriterInterceptor {
    @Override
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        try {
            return context.proceed();
        }
        catch (WebApplicationException | MessageBodyProviderNotFoundException | MappableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappableException(e);
        }
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try {
            context.proceed();
        }
        catch (WebApplicationException | MappableException e) {
            throw e;
        }
        catch (MessageBodyProviderNotFoundException nfe) {
            throw new InternalServerErrorException(nfe);
        }
        catch (Exception e) {
            throw new MappableException(e);
        }
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bind(MappableExceptionWrapperInterceptor.class).to(ReaderInterceptor.class).to(WriterInterceptor.class).in(Singleton.class);
        }
    }
}

