/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.internal.process;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import shaded.javax.ws.rs.container.AsyncResponse;
import shaded.javax.ws.rs.container.ContainerRequestContext;
import shaded.javax.ws.rs.container.ResourceInfo;
import shaded.javax.ws.rs.core.HttpHeaders;
import shaded.javax.ws.rs.core.Request;
import shaded.javax.ws.rs.core.SecurityContext;
import shaded.javax.ws.rs.core.UriInfo;
import shaded.org.glassfish.hk2.api.TypeLiteral;
import shaded.org.glassfish.hk2.utilities.binding.AbstractBinder;
import shaded.org.glassfish.jersey.internal.inject.ReferenceTransformingFactory;
import shaded.org.glassfish.jersey.internal.inject.ReferencingFactory;
import shaded.org.glassfish.jersey.internal.util.collection.Ref;
import shaded.org.glassfish.jersey.process.internal.RequestScoped;
import shaded.org.glassfish.jersey.server.BackgroundScheduler;
import shaded.org.glassfish.jersey.server.BackgroundSchedulerLiteral;
import shaded.org.glassfish.jersey.server.CloseableService;
import shaded.org.glassfish.jersey.server.ContainerRequest;
import shaded.org.glassfish.jersey.server.ExtendedUriInfo;
import shaded.org.glassfish.jersey.server.ManagedAsyncExecutor;
import shaded.org.glassfish.jersey.server.internal.process.AsyncContext;
import shaded.org.glassfish.jersey.server.internal.process.ReferencesInitializer;
import shaded.org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import shaded.org.glassfish.jersey.server.internal.process.SecurityContextInjectee;
import shaded.org.glassfish.jersey.server.internal.routing.UriRoutingContext;
import shaded.org.glassfish.jersey.spi.ExecutorServiceProvider;
import shaded.org.glassfish.jersey.spi.ScheduledExecutorServiceProvider;
import shaded.org.glassfish.jersey.spi.ScheduledThreadPoolExecutorProvider;
import shaded.org.glassfish.jersey.spi.ThreadPoolExecutorProvider;

public class ServerProcessingBinder
extends AbstractBinder {
    @Override
    protected void configure() {
        this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<RequestProcessingContext>>(){}).proxy(false).in(RequestScoped.class);
        this.bindFactory(ContainerRequestFactory.class).to(ContainerRequest.class).to(ContainerRequestContext.class).proxy(false).in(RequestScoped.class);
        this.bindFactory(ContainerRequestFactory.class).to(HttpHeaders.class).to(Request.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
        this.bindFactory(UriRoutingContextFactory.class).to(UriInfo.class).to(ExtendedUriInfo.class).to(ResourceInfo.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
        this.bind(SecurityContextInjectee.class).to(SecurityContext.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
        this.bindFactory(CloseableServiceFactory.class).to(CloseableService.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
        this.bindFactory(AsyncContextFactory.class).to(AsyncContext.class).to(AsyncResponse.class).in(RequestScoped.class);
        this.bind(DefaultBackgroundSchedulerProvider.class).to(ScheduledExecutorServiceProvider.class).qualifiedBy(BackgroundSchedulerLiteral.INSTANCE).in(Singleton.class);
        this.bind(DefaultManagedAsyncExecutorProvider.class).to(ExecutorServiceProvider.class).in(Singleton.class);
        this.bindAsContract(ReferencesInitializer.class);
    }

    @ManagedAsyncExecutor
    private static class DefaultManagedAsyncExecutorProvider
    extends ThreadPoolExecutorProvider {
        public DefaultManagedAsyncExecutorProvider() {
            super("shaded.jersey-server-managed-async-executor");
        }
    }

    @BackgroundScheduler
    private static class DefaultBackgroundSchedulerProvider
    extends ScheduledThreadPoolExecutorProvider {
        public DefaultBackgroundSchedulerProvider() {
            super("shaded.jersey-background-task-scheduler");
        }

        @Override
        protected int getCorePoolSize() {
            return 1;
        }
    }

    private static class AsyncContextFactory
    extends ReferenceTransformingFactory<RequestProcessingContext, AsyncContext> {
        @Inject
        protected AsyncContextFactory(Provider<Ref<RequestProcessingContext>> refProvider) {
            super(refProvider, new ReferenceTransformingFactory.Transformer<RequestProcessingContext, AsyncContext>(){

                @Override
                public AsyncContext transform(RequestProcessingContext value) {
                    return value.asyncContext();
                }
            });
        }

        @Override
        @RequestScoped
        public AsyncContext provide() {
            return (AsyncContext)super.provide();
        }
    }

    private static class CloseableServiceFactory
    extends ReferenceTransformingFactory<RequestProcessingContext, CloseableService> {
        @Inject
        protected CloseableServiceFactory(Provider<Ref<RequestProcessingContext>> refProvider) {
            super(refProvider, new ReferenceTransformingFactory.Transformer<RequestProcessingContext, CloseableService>(){

                @Override
                public CloseableService transform(RequestProcessingContext value) {
                    return value.closeableService();
                }
            });
        }

        @Override
        @RequestScoped
        public CloseableService provide() {
            return (CloseableService)super.provide();
        }
    }

    private static class UriRoutingContextFactory
    extends ReferenceTransformingFactory<RequestProcessingContext, UriRoutingContext> {
        @Inject
        protected UriRoutingContextFactory(Provider<Ref<RequestProcessingContext>> refProvider) {
            super(refProvider, new ReferenceTransformingFactory.Transformer<RequestProcessingContext, UriRoutingContext>(){

                @Override
                public UriRoutingContext transform(RequestProcessingContext value) {
                    return value.uriRoutingContext();
                }
            });
        }

        @Override
        @RequestScoped
        public UriRoutingContext provide() {
            return (UriRoutingContext)super.provide();
        }
    }

    private static class ContainerRequestFactory
    extends ReferenceTransformingFactory<RequestProcessingContext, ContainerRequest> {
        @Inject
        protected ContainerRequestFactory(Provider<Ref<RequestProcessingContext>> refProvider) {
            super(refProvider, new ReferenceTransformingFactory.Transformer<RequestProcessingContext, ContainerRequest>(){

                @Override
                public ContainerRequest transform(RequestProcessingContext value) {
                    return value.request();
                }
            });
        }

        @Override
        @RequestScoped
        public ContainerRequest provide() {
            return (ContainerRequest)super.provide();
        }
    }
}

