/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.internal.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.evomaster.clientJava.controller.internal.db.CheckExprExtractor;
import org.evomaster.clientJava.controller.internal.db.LowerBoundConstraint;
import org.evomaster.clientJava.controller.internal.db.RangeConstraint;
import org.evomaster.clientJava.controller.internal.db.SchemaConstraint;
import org.evomaster.clientJava.controller.internal.db.UpperBoundConstraint;
import org.evomaster.clientJava.controllerApi.dto.database.schema.ColumnDto;
import org.evomaster.clientJava.controllerApi.dto.database.schema.DatabaseType;
import org.evomaster.clientJava.controllerApi.dto.database.schema.DbSchemaDto;
import org.evomaster.clientJava.controllerApi.dto.database.schema.ForeignKeyDto;
import org.evomaster.clientJava.controllerApi.dto.database.schema.TableDto;
import shaded.net.sf.jsqlparser.JSQLParserException;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.parser.CCJSqlParserUtil;

public class SchemaExtractor {
    public static DbSchemaDto extract(Connection connection) throws Exception {
        Objects.requireNonNull(connection);
        DbSchemaDto schemaDto = new DbSchemaDto();
        try {
            schemaDto.name = connection.getSchema();
        }
        catch (AbstractMethodError | Exception e) {
            schemaDto.name = "public";
        }
        DatabaseMetaData md = connection.getMetaData();
        String protocol = md.getURL();
        DatabaseType dt = DatabaseType.OTHER;
        if (protocol.contains(":h2")) {
            dt = DatabaseType.H2;
        } else if (protocol.contains(":derby")) {
            dt = DatabaseType.DERBY;
        }
        schemaDto.databaseType = dt;
        ResultSet tables = md.getTables(null, schemaDto.name.toUpperCase(), null, new String[]{"TABLE"});
        HashSet<String> tableNames = new HashSet<String>();
        while (tables.next()) {
            TableDto tableDto = new TableDto();
            schemaDto.tables.add(tableDto);
            tableDto.name = tables.getString("TABLE_NAME");
            if (tableNames.contains(tableDto.name)) {
                throw new IllegalArgumentException("Cannot handle repeated table " + tableDto.name + " in schema");
            }
            tableNames.add(tableDto.name);
            HashSet<String> pks = new HashSet<String>();
            TreeMap<Integer, String> primaryKeySequence = new TreeMap<Integer, String>();
            ResultSet rsPK = md.getPrimaryKeys(null, null, tableDto.name);
            while (rsPK.next()) {
                String pkColumnName = rsPK.getString("COLUMN_NAME");
                short positionInPrimaryKey = rsPK.getShort("KEY_SEQ");
                pks.add(pkColumnName);
                int pkIndex = positionInPrimaryKey - 1;
                primaryKeySequence.put(pkIndex, pkColumnName);
            }
            rsPK.close();
            tableDto.primaryKeySequence.addAll(primaryKeySequence.values());
            ResultSet columns = md.getColumns(null, schemaDto.name.toUpperCase(), tableDto.name, null);
            HashSet<String> columnNames = new HashSet<String>();
            while (columns.next()) {
                ColumnDto columnDto = new ColumnDto();
                tableDto.columns.add(columnDto);
                columnDto.table = tableDto.name;
                columnDto.name = columns.getString("COLUMN_NAME");
                if (columnNames.contains(columnDto.name)) {
                    throw new IllegalArgumentException("Cannot handle repeated column " + columnDto.name + " in table " + tableDto.name);
                }
                columnNames.add(columnDto.name);
                columnDto.type = columns.getString("TYPE_NAME");
                columnDto.size = columns.getInt("COLUMN_SIZE");
                columnDto.nullable = columns.getBoolean("IS_NULLABLE");
                columnDto.autoIncrement = columns.getBoolean("IS_AUTOINCREMENT");
                columnDto.primaryKey = pks.contains(columnDto.name);
            }
            columns.close();
            ResultSet fks = md.getImportedKeys(null, null, tableDto.name);
            while (fks.next()) {
                ForeignKeyDto fkDto = new ForeignKeyDto();
                fkDto.sourceColumns.add(fks.getString("FKCOLUMN_NAME"));
                fkDto.targetTable = fks.getString("PKTABLE_NAME");
                tableDto.foreignKeys.add(fkDto);
            }
            fks.close();
        }
        tables.close();
        SchemaExtractor.addForeignKeyToAutoIncrement(schemaDto);
        SchemaExtractor.addConstraints(connection, dt, schemaDto);
        return schemaDto;
    }

    private static void addForeignKeyToAutoIncrement(DbSchemaDto schema) {
        for (TableDto tableDto : schema.tables) {
            String tableName = tableDto.name;
            for (ColumnDto columnDto : tableDto.columns) {
                String columnName;
                if (columnDto.autoIncrement || !columnDto.primaryKey || !tableDto.foreignKeys.stream().anyMatch(fk -> fk.sourceColumns.contains(columnDto.name)) || !SchemaExtractor.isFKToAutoIncrementColumn(schema, tableName, columnName = columnDto.name)) continue;
                columnDto.foreignKeyToAutoIncrement = true;
            }
        }
    }

    private static TableDto getTable(DbSchemaDto schema, String tableName) {
        TableDto tableDto = schema.tables.stream().filter(t -> t.name.equalsIgnoreCase(tableName)).findFirst().orElse(null);
        return tableDto;
    }

    private static String getColumnNameForeignKeyToAutoIncrementColumn(DbSchemaDto schema, String tableName) {
        TableDto tableDto = SchemaExtractor.getTable(schema, tableName);
        for (String pkColumnName : tableDto.primaryKeySequence) {
            if (!SchemaExtractor.isFKToAutoIncrementColumn(schema, tableName, pkColumnName)) continue;
            return pkColumnName;
        }
        return null;
    }

    private static boolean isFKToAutoIncrementColumn(DbSchemaDto schema, String tableName, String columnName) {
        TableDto tableDto = SchemaExtractor.getTable(schema, tableName);
        if (tableDto.columns.stream().anyMatch(c -> c.name.equalsIgnoreCase(columnName) && c.primaryKey)) {
            if (tableDto.columns.stream().anyMatch(c -> c.name.equalsIgnoreCase(columnName) && c.autoIncrement)) {
                return true;
            }
            for (ForeignKeyDto fk : tableDto.foreignKeys) {
                if (!fk.sourceColumns.contains(columnName)) continue;
                int positionInFKSequence = fk.sourceColumns.indexOf(columnName);
                String targetTableName = fk.targetTable;
                TableDto targetTableDto = SchemaExtractor.getTable(schema, targetTableName);
                String targetColumnName = targetTableDto.primaryKeySequence.get(positionInFKSequence);
                if (!SchemaExtractor.isFKToAutoIncrementColumn(schema, targetTableName, targetColumnName)) continue;
                return true;
            }
        }
        return false;
    }

    private static void addConstraints(Connection connection, DatabaseType dt, DbSchemaDto schemaDto) throws SQLException, JSQLParserException {
        switch (dt) {
            case H2: {
                SchemaExtractor.addH2Constraints(connection, schemaDto);
                break;
            }
            case DERBY: {
                break;
            }
            case OTHER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown database type " + (Object)((Object)dt));
            }
        }
    }

    private static void addH2Constraints(Connection connectionToH2, DbSchemaDto schemaDto) throws SQLException, JSQLParserException {
        SchemaExtractor.addH2ColumnConstraints(connectionToH2, schemaDto);
        SchemaExtractor.addH2TableConstraints(connectionToH2, schemaDto);
    }

    private static void addH2TableConstraints(Connection connectionToH2, DbSchemaDto schemaDto) throws SQLException, JSQLParserException {
        String tableSchema = schemaDto.name;
        for (TableDto tableDto : schemaDto.tables) {
            String tableName = tableDto.name;
            Statement statement = connectionToH2.createStatement();
            ResultSet constraints = statement.executeQuery("Select * From INFORMATION_SCHEMA.CONSTRAINTS  where CONSTRAINTS.TABLE_SCHEMA='" + tableSchema + "' and CONSTRAINTS.TABLE_NAME='" + tableName + "'");
            while (constraints.next()) {
                String tableCatalog = constraints.getString("TABLE_CATALOG");
                String constraintCatalog = constraints.getString("CONSTRAINT_CATALOG");
                String constraintSchema = constraints.getString("CONSTRAINT_SCHEMA");
                String constraintName = constraints.getString("CONSTRAINT_NAME");
                String constraintType = constraints.getString("CONSTRAINT_TYPE");
                String uniqueIndexName = constraints.getString("UNIQUE_INDEX_NAME");
                String checkExpression = constraints.getString("CHECK_EXPRESSION");
                String columnList = constraints.getString("COLUMN_LIST");
                if (constraintType.equals("UNIQUE")) {
                    assert (checkExpression == null);
                    String[] uniqueColumnNames = columnList.split(",");
                    for (int i = 0; i < uniqueColumnNames.length; ++i) {
                        String columnName = uniqueColumnNames[i].trim();
                        SchemaExtractor.addUniqueConstraintToColumn(tableName, tableDto, columnName);
                    }
                    continue;
                }
                if (constraintType.equals("REFERENTIAL") || constraintType.equals("PRIMARY KEY")) continue;
                if (constraintType.equals("CHECK")) {
                    assert (columnList == null);
                    SchemaExtractor.addH2CheckConstraint(tableDto, checkExpression);
                    continue;
                }
                throw new RuntimeException("Unknown constraint type : " + constraintType);
            }
            statement.close();
        }
    }

    private static void addH2CheckConstraint(TableDto tableDto, String condExpression) throws JSQLParserException {
        Expression expr = CCJSqlParserUtil.parseCondExpression(condExpression);
        CheckExprExtractor exprExtractor = new CheckExprExtractor();
        expr.accept(exprExtractor);
        String tableName = tableDto.name;
        List<SchemaConstraint> constraints = exprExtractor.getConstraints();
        for (SchemaConstraint constraint : constraints) {
            ColumnDto columnDto;
            String columnName;
            if (constraint instanceof LowerBoundConstraint) {
                LowerBoundConstraint lowerBound = (LowerBoundConstraint)constraint;
                columnName = lowerBound.getColumnName();
                columnDto = tableDto.columns.stream().filter(c -> c.name.equalsIgnoreCase(columnName)).findFirst().orElse(null);
                if (columnDto == null) {
                    throw new IllegalArgumentException("Column " + columnName + " was not found in table " + tableName);
                }
                columnDto.lowerBound = (int)lowerBound.getLowerBound();
                continue;
            }
            if (constraint instanceof UpperBoundConstraint) {
                UpperBoundConstraint upperBound = (UpperBoundConstraint)constraint;
                columnName = upperBound.getColumnName();
                columnDto = tableDto.columns.stream().filter(c -> c.name.equalsIgnoreCase(columnName)).findFirst().orElse(null);
                if (columnDto == null) {
                    throw new IllegalArgumentException("Column " + columnName + " was not found in table " + tableName);
                }
                columnDto.upperBound = (int)upperBound.getUpperBound();
                continue;
            }
            if (constraint instanceof RangeConstraint) {
                RangeConstraint rangeConstraint = (RangeConstraint)constraint;
                columnName = rangeConstraint.getColumnName();
                columnDto = tableDto.columns.stream().filter(c -> c.name.equalsIgnoreCase(columnName)).findFirst().orElse(null);
                if (columnDto == null) {
                    throw new IllegalArgumentException("Column " + columnName + " was not found in table " + tableName);
                }
                columnDto.lowerBound = (int)rangeConstraint.getMinValue();
                columnDto.upperBound = (int)rangeConstraint.getMaxValue();
                continue;
            }
            throw new RuntimeException("Unknown constraint type " + constraint.getClass().getName());
        }
    }

    private static void addH2ColumnConstraints(Connection connectionToH2, DbSchemaDto schemaDto) throws SQLException, JSQLParserException {
        String tableSchema = schemaDto.name;
        for (TableDto tableDto : schemaDto.tables) {
            String tableName = tableDto.name;
            Statement statement = connectionToH2.createStatement();
            ResultSet columns = statement.executeQuery("Select * From INFORMATION_SCHEMA.COLUMNS  where COLUMNS.TABLE_SCHEMA='" + tableSchema + "' and COLUMNS.TABLE_NAME='" + tableName + "'");
            while (columns.next()) {
                String tableCatalog = columns.getString("TABLE_CATALOG");
                String columnName = columns.getString("COLUMN_NAME");
                String checkConstraint = columns.getString("CHECK_CONSTRAINT");
                if (checkConstraint == null || checkConstraint.equals("")) continue;
                SchemaExtractor.addH2CheckConstraint(tableDto, checkConstraint);
            }
            statement.close();
        }
    }

    private static void addUniqueConstraintToColumn(String tableName, TableDto tableDto, String columnName) {
        ColumnDto columnDto = tableDto.columns.stream().filter(c -> c.name.equals(columnName)).findAny().orElse(null);
        if (columnDto == null) {
            throw new IllegalArgumentException("Missing column DTO for column:" + tableName + "." + columnName);
        }
        columnDto.unique = true;
    }
}

