/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import shaded.net.sf.jsqlparser.expression.AllComparisonExpression;
import shaded.net.sf.jsqlparser.expression.AnalyticExpression;
import shaded.net.sf.jsqlparser.expression.AnyComparisonExpression;
import shaded.net.sf.jsqlparser.expression.BinaryExpression;
import shaded.net.sf.jsqlparser.expression.CaseExpression;
import shaded.net.sf.jsqlparser.expression.CastExpression;
import shaded.net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import shaded.net.sf.jsqlparser.expression.DateValue;
import shaded.net.sf.jsqlparser.expression.DoubleValue;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import shaded.net.sf.jsqlparser.expression.ExtractExpression;
import shaded.net.sf.jsqlparser.expression.Function;
import shaded.net.sf.jsqlparser.expression.HexValue;
import shaded.net.sf.jsqlparser.expression.IntervalExpression;
import shaded.net.sf.jsqlparser.expression.JdbcNamedParameter;
import shaded.net.sf.jsqlparser.expression.JdbcParameter;
import shaded.net.sf.jsqlparser.expression.JsonExpression;
import shaded.net.sf.jsqlparser.expression.KeepExpression;
import shaded.net.sf.jsqlparser.expression.LongValue;
import shaded.net.sf.jsqlparser.expression.MySQLGroupConcat;
import shaded.net.sf.jsqlparser.expression.NotExpression;
import shaded.net.sf.jsqlparser.expression.NullValue;
import shaded.net.sf.jsqlparser.expression.NumericBind;
import shaded.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import shaded.net.sf.jsqlparser.expression.OracleHint;
import shaded.net.sf.jsqlparser.expression.Parenthesis;
import shaded.net.sf.jsqlparser.expression.RowConstructor;
import shaded.net.sf.jsqlparser.expression.SignedExpression;
import shaded.net.sf.jsqlparser.expression.StringValue;
import shaded.net.sf.jsqlparser.expression.TimeKeyExpression;
import shaded.net.sf.jsqlparser.expression.TimeValue;
import shaded.net.sf.jsqlparser.expression.TimestampValue;
import shaded.net.sf.jsqlparser.expression.UserVariable;
import shaded.net.sf.jsqlparser.expression.WhenClause;
import shaded.net.sf.jsqlparser.expression.WindowElement;
import shaded.net.sf.jsqlparser.expression.WithinGroupExpression;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Division;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import shaded.net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import shaded.net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.Between;
import shaded.net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import shaded.net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import shaded.net.sf.jsqlparser.expression.operators.relational.InExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import shaded.net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import shaded.net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.Matches;
import shaded.net.sf.jsqlparser.expression.operators.relational.MinorThan;
import shaded.net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import shaded.net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import shaded.net.sf.jsqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import shaded.net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.select.OrderByElement;
import shaded.net.sf.jsqlparser.statement.select.SelectVisitor;
import shaded.net.sf.jsqlparser.statement.select.SubSelect;
import shaded.net.sf.jsqlparser.statement.select.WithItem;
import shaded.net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class ExpressionDeParser
implements ExpressionVisitor,
ItemsListVisitor {
    private static final String NOT = "NOT ";
    private StringBuilder buffer = new StringBuilder();
    private SelectVisitor selectVisitor;
    private boolean useBracketsInExprList = true;
    private OrderByDeParser orderByDeParser = new OrderByDeParser();

    public ExpressionDeParser() {
    }

    public ExpressionDeParser(SelectVisitor selectVisitor, StringBuilder buffer) {
        this(selectVisitor, buffer, new OrderByDeParser());
    }

    ExpressionDeParser(SelectVisitor selectVisitor, StringBuilder buffer, OrderByDeParser orderByDeParser) {
        this.selectVisitor = selectVisitor;
        this.buffer = buffer;
        this.orderByDeParser = orderByDeParser;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(Addition addition) {
        this.visitBinaryExpression(addition, " + ");
    }

    @Override
    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression(andExpression, " AND ");
    }

    @Override
    public void visit(Between between) {
        between.getLeftExpression().accept(this);
        if (between.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" BETWEEN ");
        between.getBetweenExpressionStart().accept(this);
        this.buffer.append(" AND ");
        between.getBetweenExpressionEnd().accept(this);
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visitOldOracleJoinBinaryExpression(equalsTo, " = ");
    }

    @Override
    public void visit(Division division) {
        this.visitBinaryExpression(division, " / ");
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.buffer.append(doubleValue.toString());
    }

    @Override
    public void visit(HexValue hexValue) {
        this.buffer.append(hexValue.toString());
    }

    @Override
    public void visit(NotExpression notExpr) {
        this.buffer.append(NOT);
        notExpr.getExpression().accept(this);
    }

    public void visitOldOracleJoinBinaryExpression(OldOracleJoinBinaryExpression expression, String operator) {
        if (expression.isNot()) {
            this.buffer.append(NOT);
        }
        expression.getLeftExpression().accept(this);
        if (expression.getOldOracleJoinSyntax() == 1) {
            this.buffer.append("(+)");
        }
        this.buffer.append(operator);
        expression.getRightExpression().accept(this);
        if (expression.getOldOracleJoinSyntax() == 2) {
            this.buffer.append("(+)");
        }
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        this.visitOldOracleJoinBinaryExpression(greaterThan, " > ");
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitOldOracleJoinBinaryExpression(greaterThanEquals, " >= ");
    }

    @Override
    public void visit(InExpression inExpression) {
        if (inExpression.getLeftExpression() == null) {
            inExpression.getLeftItemsList().accept(this);
        } else {
            inExpression.getLeftExpression().accept(this);
            if (inExpression.getOldOracleJoinSyntax() == 1) {
                this.buffer.append("(+)");
            }
        }
        if (inExpression.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" IN ");
        inExpression.getRightItemsList().accept(this);
    }

    @Override
    public void visit(SignedExpression signedExpression) {
        this.buffer.append(signedExpression.getSign());
        signedExpression.getExpression().accept(this);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        isNullExpression.getLeftExpression().accept(this);
        if (isNullExpression.isNot()) {
            this.buffer.append(" IS NOT NULL");
        } else {
            this.buffer.append(" IS NULL");
        }
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.buffer.append("?");
        if (jdbcParameter.isUseFixedIndex()) {
            this.buffer.append(jdbcParameter.getIndex());
        }
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.visitBinaryExpression(likeExpression, likeExpression.isCaseInsensitive() ? " ILIKE " : " LIKE ");
        String escape = likeExpression.getEscape();
        if (escape != null) {
            this.buffer.append(" ESCAPE '").append(escape).append('\'');
        }
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        if (existsExpression.isNot()) {
            this.buffer.append("NOT EXISTS ");
        } else {
            this.buffer.append("EXISTS ");
        }
        existsExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(LongValue longValue) {
        this.buffer.append(longValue.getStringValue());
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visitOldOracleJoinBinaryExpression(minorThan, " < ");
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visitOldOracleJoinBinaryExpression(minorThanEquals, " <= ");
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression(multiplication, " * ");
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visitOldOracleJoinBinaryExpression(notEqualsTo, " " + notEqualsTo.getStringExpression() + " ");
    }

    @Override
    public void visit(NullValue nullValue) {
        this.buffer.append(nullValue.toString());
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression, " OR ");
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        if (parenthesis.isNot()) {
            this.buffer.append(NOT);
        }
        this.buffer.append("(");
        parenthesis.getExpression().accept(this);
        this.buffer.append(")");
    }

    @Override
    public void visit(StringValue stringValue) {
        this.buffer.append("'").append(stringValue.getValue()).append("'");
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression(subtraction, " - ");
    }

    private void visitBinaryExpression(BinaryExpression binaryExpression, String operator) {
        if (binaryExpression.isNot()) {
            this.buffer.append(NOT);
        }
        binaryExpression.getLeftExpression().accept(this);
        this.buffer.append(operator);
        binaryExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(SubSelect subSelect) {
        this.buffer.append("(");
        if (this.selectVisitor != null) {
            if (subSelect.getWithItemsList() != null) {
                this.buffer.append("WITH ");
                Iterator<WithItem> iter = subSelect.getWithItemsList().iterator();
                while (iter.hasNext()) {
                    iter.next().accept(this.selectVisitor);
                    if (iter.hasNext()) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append(" ");
                }
                this.buffer.append(" ");
            }
            subSelect.getSelectBody().accept(this.selectVisitor);
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(Column tableColumn) {
        Table table = tableColumn.getTable();
        String tableName = null;
        if (table != null) {
            tableName = table.getAlias() != null ? table.getAlias().getName() : table.getFullyQualifiedName();
        }
        if (tableName != null && !tableName.isEmpty()) {
            this.buffer.append(tableName).append(".");
        }
        this.buffer.append(tableColumn.getColumnName());
    }

    @Override
    public void visit(Function function) {
        if (function.isEscaped()) {
            this.buffer.append("{fn ");
        }
        this.buffer.append(function.getName());
        if (function.isAllColumns() && function.getParameters() == null) {
            this.buffer.append("(*)");
        } else if (function.getParameters() == null) {
            this.buffer.append("()");
        } else {
            boolean oldUseBracketsInExprList = this.useBracketsInExprList;
            if (function.isDistinct()) {
                this.useBracketsInExprList = false;
                this.buffer.append("(DISTINCT ");
            } else if (function.isAllColumns()) {
                this.useBracketsInExprList = false;
                this.buffer.append("(ALL ");
            }
            this.visit(function.getParameters());
            this.useBracketsInExprList = oldUseBracketsInExprList;
            if (function.isDistinct() || function.isAllColumns()) {
                this.buffer.append(")");
            }
        }
        if (function.getAttribute() != null) {
            this.buffer.append(".").append(function.getAttribute());
        }
        if (function.getKeep() != null) {
            this.buffer.append(" ").append(function.getKeep());
        }
        if (function.isEscaped()) {
            this.buffer.append("}");
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        if (this.useBracketsInExprList) {
            this.buffer.append("(");
        }
        Iterator<Expression> iter = expressionList.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = iter.next();
            expression.accept(this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (this.useBracketsInExprList) {
            this.buffer.append(")");
        }
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }

    @Override
    public void visit(DateValue dateValue) {
        this.buffer.append("{d '").append(dateValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.buffer.append("{ts '").append(timestampValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.buffer.append("{t '").append(timeValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        this.buffer.append("CASE ");
        Expression switchExp = caseExpression.getSwitchExpression();
        if (switchExp != null) {
            switchExp.accept(this);
            this.buffer.append(" ");
        }
        for (Expression exp : caseExpression.getWhenClauses()) {
            exp.accept(this);
        }
        Expression elseExp = caseExpression.getElseExpression();
        if (elseExp != null) {
            this.buffer.append("ELSE ");
            elseExp.accept(this);
            this.buffer.append(" ");
        }
        this.buffer.append("END");
    }

    @Override
    public void visit(WhenClause whenClause) {
        this.buffer.append("WHEN ");
        whenClause.getWhenExpression().accept(this);
        this.buffer.append(" THEN ");
        whenClause.getThenExpression().accept(this);
        this.buffer.append(" ");
    }

    @Override
    public void visit(AllComparisonExpression allComparisonExpression) {
        this.buffer.append("ALL ");
        allComparisonExpression.getSubSelect().accept(this);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        this.buffer.append(anyComparisonExpression.getAnyType().name()).append(" ");
        anyComparisonExpression.getSubSelect().accept(this);
    }

    @Override
    public void visit(Concat concat) {
        this.visitBinaryExpression(concat, " || ");
    }

    @Override
    public void visit(Matches matches) {
        this.visitOldOracleJoinBinaryExpression(matches, " @@ ");
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression(bitwiseAnd, " & ");
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression(bitwiseOr, " | ");
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression(bitwiseXor, " ^ ");
    }

    @Override
    public void visit(CastExpression cast) {
        if (cast.isUseCastKeyword()) {
            this.buffer.append("CAST(");
            this.buffer.append(cast.getLeftExpression());
            this.buffer.append(" AS ");
            this.buffer.append(cast.getType());
            this.buffer.append(")");
        } else {
            this.buffer.append(cast.getLeftExpression());
            this.buffer.append("::");
            this.buffer.append(cast.getType());
        }
    }

    @Override
    public void visit(Modulo modulo) {
        this.visitBinaryExpression(modulo, " % ");
    }

    @Override
    public void visit(AnalyticExpression aexpr) {
        String name = aexpr.getName();
        Expression expression = aexpr.getExpression();
        Expression offset = aexpr.getOffset();
        Expression defaultValue = aexpr.getDefaultValue();
        boolean isAllColumns = aexpr.isAllColumns();
        KeepExpression keep = aexpr.getKeep();
        ExpressionList partitionExpressionList = aexpr.getPartitionExpressionList();
        List<OrderByElement> orderByElements = aexpr.getOrderByElements();
        WindowElement windowElement = aexpr.getWindowElement();
        this.buffer.append(name).append("(");
        if (expression != null) {
            expression.accept(this);
            if (offset != null) {
                this.buffer.append(", ");
                offset.accept(this);
                if (defaultValue != null) {
                    this.buffer.append(", ");
                    defaultValue.accept(this);
                }
            }
        } else if (isAllColumns) {
            this.buffer.append("*");
        }
        this.buffer.append(") ");
        if (keep != null) {
            keep.accept(this);
            this.buffer.append(" ");
        }
        this.buffer.append("OVER (");
        if (partitionExpressionList != null && !partitionExpressionList.getExpressions().isEmpty()) {
            this.buffer.append("PARTITION BY ");
            List<Expression> expressions = partitionExpressionList.getExpressions();
            for (int i = 0; i < expressions.size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                expressions.get(i).accept(this);
            }
            this.buffer.append(" ");
        }
        if (orderByElements != null && !orderByElements.isEmpty()) {
            this.buffer.append("ORDER BY ");
            this.orderByDeParser.setExpressionVisitor(this);
            this.orderByDeParser.setBuffer(this.buffer);
            for (int i = 0; i < orderByElements.size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                this.orderByDeParser.deParseElement(orderByElements.get(i));
            }
            if (windowElement != null) {
                this.buffer.append(' ');
                this.buffer.append(windowElement);
            }
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(ExtractExpression eexpr) {
        this.buffer.append("EXTRACT(").append(eexpr.getName());
        this.buffer.append(" FROM ");
        eexpr.getExpression().accept(this);
        this.buffer.append(')');
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        Iterator<ExpressionList> it = multiExprList.getExprList().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(IntervalExpression iexpr) {
        this.buffer.append(iexpr.toString());
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        this.buffer.append(jdbcNamedParameter.toString());
    }

    @Override
    public void visit(OracleHierarchicalExpression oexpr) {
        this.buffer.append(oexpr.toString());
    }

    @Override
    public void visit(RegExpMatchOperator rexpr) {
        this.visitBinaryExpression(rexpr, " " + rexpr.getStringExpression() + " ");
    }

    @Override
    public void visit(RegExpMySQLOperator rexpr) {
        this.visitBinaryExpression(rexpr, " " + rexpr.getStringExpression() + " ");
    }

    @Override
    public void visit(JsonExpression jsonExpr) {
        this.buffer.append(jsonExpr.toString());
    }

    @Override
    public void visit(JsonOperator jsonExpr) {
        this.visitBinaryExpression(jsonExpr, " " + jsonExpr.getStringExpression() + " ");
    }

    @Override
    public void visit(WithinGroupExpression wgexpr) {
        this.buffer.append(wgexpr.toString());
    }

    @Override
    public void visit(UserVariable var) {
        this.buffer.append(var.toString());
    }

    @Override
    public void visit(NumericBind bind) {
        this.buffer.append(bind.toString());
    }

    @Override
    public void visit(KeepExpression aexpr) {
        this.buffer.append(aexpr.toString());
    }

    @Override
    public void visit(MySQLGroupConcat groupConcat) {
        this.buffer.append(groupConcat.toString());
    }

    @Override
    public void visit(RowConstructor rowConstructor) {
        if (rowConstructor.getName() != null) {
            this.buffer.append(rowConstructor.getName());
        }
        this.buffer.append("(");
        boolean first = true;
        for (Expression expr : rowConstructor.getExprList().getExpressions()) {
            if (first) {
                first = false;
            } else {
                this.buffer.append(", ");
            }
            expr.accept(this);
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(OracleHint hint) {
        this.buffer.append(hint.toString());
    }

    @Override
    public void visit(TimeKeyExpression timeKeyExpression) {
        this.buffer.append(timeKeyExpression.toString());
    }

    @Override
    public void visit(DateTimeLiteralExpression literal) {
        this.buffer.append(literal.toString());
    }
}

