/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.jackson;

import shaded.com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import shaded.com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import shaded.com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import shaded.javax.ws.rs.core.Configuration;
import shaded.javax.ws.rs.core.Feature;
import shaded.javax.ws.rs.core.FeatureContext;
import shaded.javax.ws.rs.ext.MessageBodyReader;
import shaded.javax.ws.rs.ext.MessageBodyWriter;
import shaded.org.glassfish.jersey.CommonProperties;
import shaded.org.glassfish.jersey.internal.util.PropertiesHelper;
import shaded.org.glassfish.jersey.jackson.internal.FilteringJacksonJaxbJsonProvider;
import shaded.org.glassfish.jersey.jackson.internal.JacksonFilteringFeature;
import shaded.org.glassfish.jersey.message.filtering.EntityFilteringFeature;

public class JacksonFeature
implements Feature {
    private static final String JSON_FEATURE = JacksonFeature.class.getSimpleName();

    @Override
    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        String jsonFeature = CommonProperties.getValue(config.getProperties(), config.getRuntimeType(), "shaded.jersey.config.jsonFeature", JSON_FEATURE, String.class);
        if (!JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            return false;
        }
        context.property(PropertiesHelper.getPropertyNameForRuntime("shaded.jersey.config.jsonFeature", config.getRuntimeType()), JSON_FEATURE);
        if (!config.isRegistered(JacksonJaxbJsonProvider.class)) {
            context.register(JsonParseExceptionMapper.class);
            context.register(JsonMappingExceptionMapper.class);
            if (EntityFilteringFeature.enabled(config)) {
                context.register(JacksonFilteringFeature.class);
                context.register(FilteringJacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            } else {
                context.register(JacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            }
        }
        return true;
    }
}

