/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller;

import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Objects;
import org.evomaster.client.java.controller.api.dto.AuthenticationDto;
import org.evomaster.client.java.controller.api.dto.HeaderDto;

public class AuthUtils {
    public static String encode64(String value) {
        Objects.requireNonNull(value);
        byte[] data = value.getBytes(Charset.forName("UTF-8"));
        byte[] encoded = Base64.getEncoder().encode(data);
        return new String(encoded);
    }

    public static AuthenticationDto getForBasic(String dtoName, String userId, String password) {
        Objects.requireNonNull(userId, password);
        String encoded = AuthUtils.encode64(userId + ":" + password);
        String headerValue = "Basic " + encoded;
        return AuthUtils.getForAuthorizationHeader(dtoName, headerValue);
    }

    public static AuthenticationDto getForAuthorizationHeader(String dtoName, String authorizationValue) {
        AuthenticationDto dto = new AuthenticationDto(dtoName);
        dto.headers.add(new HeaderDto("Authorization", authorizationValue));
        return dto;
    }
}

