/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.heuristic;

import org.evomaster.client.java.instrumentation.heuristic.Truthness;

public class HeuristicsForJumps {
    public static Truthness getForSingleValueJump(int value, int opcode) {
        switch (opcode) {
            case 153: {
                return HeuristicsForJumps.getForValueComparison(value, 0, 159);
            }
            case 154: {
                return HeuristicsForJumps.getForSingleValueJump(value, 153).invert();
            }
            case 155: {
                return HeuristicsForJumps.getForValueComparison(value, 0, 161);
            }
            case 156: {
                return HeuristicsForJumps.getForSingleValueJump(value, 155).invert();
            }
            case 158: {
                return HeuristicsForJumps.getForValueComparison(0, value, 161).invert();
            }
            case 157: {
                return HeuristicsForJumps.getForValueComparison(0, value, 161);
            }
        }
        throw new IllegalArgumentException("Cannot handle opcode " + opcode);
    }

    public static Truthness getForValueComparison(int firstValue, int secondValue, int opcode) {
        double a = firstValue;
        double b = secondValue;
        switch (opcode) {
            case 159: {
                return new Truthness(1.0 - Truthness.normalizeValue(Math.abs(a - b)), a != b ? 1.0 : 0.0);
            }
            case 160: {
                return HeuristicsForJumps.getForValueComparison(firstValue, secondValue, 159).invert();
            }
            case 161: {
                return new Truthness(a < b ? 1.0 : 1.0 / (1.1 + a - b), a >= b ? 1.0 : 1.0 / (1.1 + b - a));
            }
            case 162: {
                return HeuristicsForJumps.getForValueComparison(firstValue, secondValue, 161).invert();
            }
            case 164: {
                return HeuristicsForJumps.getForValueComparison(secondValue, firstValue, 161).invert();
            }
            case 163: {
                return HeuristicsForJumps.getForValueComparison(secondValue, firstValue, 161);
            }
        }
        throw new IllegalArgumentException("Cannot handle opcode " + opcode);
    }

    public static Truthness getForObjectComparison(Object first, Object second, int opcode) {
        switch (opcode) {
            case 165: {
                return new Truthness(first == second ? 1.0 : 0.0, first != second ? 1.0 : 0.0);
            }
            case 166: {
                return HeuristicsForJumps.getForObjectComparison(first, second, 165).invert();
            }
        }
        throw new IllegalArgumentException("Cannot handle opcode " + opcode);
    }

    public static Truthness getForNullComparison(Object obj, int opcode) {
        switch (opcode) {
            case 198: {
                return HeuristicsForJumps.getForObjectComparison(obj, null, 165);
            }
            case 199: {
                return HeuristicsForJumps.getForObjectComparison(obj, null, 166);
            }
        }
        throw new IllegalArgumentException("Cannot handle opcode " + opcode);
    }
}

