/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.testabilityexception;

public class ExceptionHeuristics {
    public static final double H_REACHED_BUT_NULL = 0.05;
    public static final double H_NOT_NULL = 0.1;
    public static final int MAX_CHAR_DISTANCE = 65536;

    public static int distanceToDigit(char c) {
        return ExceptionHeuristics.distanceToRange(c, '0', '9');
    }

    public static int distanceToRange(char c, char minInclusive, char maxInclusive) {
        if (minInclusive >= maxInclusive) {
            throw new IllegalArgumentException("Invalid char range '" + minInclusive + "'-'" + maxInclusive + "'");
        }
        int diffAfter = minInclusive - c;
        int diffBefore = c - maxInclusive;
        int dist = Math.max(diffAfter, 0) + Math.max(diffBefore, 0);
        return dist;
    }

    public static int distanceToChar(char c, char target) {
        return Math.abs(c - target);
    }
}

