/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.testabilityexception;

import org.evomaster.client.java.instrumentation.testabilityexception.IntegerExceptionHeuristics;
import org.evomaster.client.java.instrumentation.testabilityexception.LocalDateExceptionHeuristics;

public class ExceptionHeuristicsRegistry {
    public static boolean shouldHandle(String owner, String name, String desc) {
        return ExceptionHeuristicsRegistry.isLocalDateParseCharSequence(owner, name, desc) || ExceptionHeuristicsRegistry.isIntegerParseIntString(owner, name, desc);
    }

    public static int numberOfInputs(String owner, String name, String desc) {
        return 1;
    }

    public static double computeHeuristics(Object input, String owner, String name, String desc) {
        if (ExceptionHeuristicsRegistry.isLocalDateParseCharSequence(owner, name, desc)) {
            return LocalDateExceptionHeuristics.parse((String)input);
        }
        if (ExceptionHeuristicsRegistry.isIntegerParseIntString(owner, name, desc)) {
            return IntegerExceptionHeuristics.parseInt((String)input);
        }
        throw new IllegalArgumentException("Cannot handle: " + owner + name + desc);
    }

    private static boolean isLocalDateParseCharSequence(String owner, String name, String desc) {
        return owner.equals("java/time/LocalDate") && name.equals("parse") && desc.equals("(Ljava/lang/CharSequence;)Ljava/time/LocalDate;");
    }

    private static boolean isIntegerParseIntString(String owner, String name, String desc) {
        return owner.equals("java/lang/Integer") && name.equals("parseInt") && desc.equals("(Ljava/lang/String;)I");
    }
}

