/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.tracker;

import org.evomaster.client.java.instrumentation.ClassName;
import org.evomaster.client.java.instrumentation.tracker.Tracker;
import shaded.org.objectweb.asm.MethodVisitor;

public class TrackerMethodVisitor
extends MethodVisitor {
    private final String className;
    private final String methodName;
    private final String descriptor;

    public TrackerMethodVisitor(MethodVisitor mv, String className, String methodName, String descriptor) {
        super(458752, mv);
        this.className = className;
        this.methodName = methodName;
        this.descriptor = descriptor;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.addTrackerIfNeeded(owner, name, desc);
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        int maxCopiedValues = 0;
        super.visitMaxs(maxStack + maxCopiedValues, maxLocals);
    }

    private void addTrackerIfNeeded(String owner, String name, String desc) {
        if (owner.equals("org/springframework/web/context/request/WebRequest")) {
            if (name.equals("getParameter") && desc.equals("(Ljava/lang/String;)Ljava/lang/String;") || name.equals("getParameterValues") && desc.equals("(Ljava/lang/String;)[Ljava/lang/String;")) {
                this.mv.visitMethodInsn(184, ClassName.get(Tracker.class).getBytecodeName(), "trackQueryParameter", "(Ljava/lang/String;)Ljava/lang/String;", Tracker.class.isInterface());
            } else if (name.equals("getHeader") && desc.equals("(Ljava/lang/String;)Ljava/lang/String;") || name.equals("getHeaderValues") && desc.equals("(Ljava/lang/String;)[Ljava/lang/String;")) {
                this.mv.visitMethodInsn(184, ClassName.get(Tracker.class).getBytecodeName(), "trackHeader", "(Ljava/lang/String;)Ljava/lang/String;", Tracker.class.isInterface());
            }
        }
    }
}

