/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Collection;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.TruthnessHelper;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class CollectionClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Collection.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean contains(Collection c, Object o, String idTemplate) {
        return CollectionClassReplacement.containsHelper(c, o, idTemplate);
    }

    protected static boolean containsHelper(Collection c, Object o, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(c);
        String inputString = null;
        if (o instanceof String) {
            inputString = (String)o;
        }
        if (ExecutionTracer.isTaintInput(inputString)) {
            for (Object value : c) {
                if (!(value instanceof String)) continue;
                ExecutionTracer.addStringSpecialization(inputString, new StringSpecializationInfo(StringSpecialization.CONSTANT, (String)value));
            }
        }
        boolean result = c.contains(o);
        if (idTemplate == null) {
            return result;
        }
        Number inputNumber = null;
        if (o instanceof Number) {
            inputNumber = (Number)o;
        }
        if (result) {
            t = new Truthness(1.0, 0.0);
        } else if (c.isEmpty()) {
            t = new Truthness(0.0, 1.0);
        } else {
            double max = 0.0;
            for (Object value : c) {
                double h;
                long distance = -1L;
                if (inputString != null && value instanceof String) {
                    distance = DistanceHelper.getLeftAlignmentDistance(inputString, (String)value);
                } else if (inputNumber != null && value instanceof Number && inputNumber instanceof Integer && value instanceof Integer) {
                    distance = Math.abs((Integer)inputNumber - (Integer)value);
                }
                if (distance <= 0L || !((h = 1.0 / (1.0 + (double)distance)) > max)) continue;
                max = h;
            }
            assert (max < 1.0);
            t = new Truthness(max, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean isEmpty(Collection caller, String idTemplate) {
        boolean result = caller.isEmpty();
        if (idTemplate == null) {
            return result;
        }
        int len = caller.size();
        Truthness t = TruthnessHelper.getTruthnessToEmpty(len);
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }
}

