/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class FloatClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Float.class;
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true)
    public static float parseFloat(String input, String idTemplate) {
        if (ExecutionTracer.isTaintInput(input)) {
            ExecutionTracer.addStringSpecialization(input, new StringSpecializationInfo(StringSpecialization.FLOAT, null));
        }
        if (idTemplate == null) {
            return Float.parseFloat(input);
        }
        try {
            float res = Float.parseFloat(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.0));
            return res;
        }
        catch (NullPointerException | NumberFormatException e) {
            double h = FloatClassReplacement.parseFloatHeuristic(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
            throw e;
        }
    }

    protected static double parseFloatHeuristic(String input) {
        if (input == null) {
            return 0.05;
        }
        double base = 0.1;
        if (input.length() == 0) {
            return 0.1;
        }
        long distance = 0L;
        if (input.length() == 1) {
            distance += (long)DistanceHelper.distanceToDigit(input.charAt(0));
        } else {
            for (int i = 0; i < input.length(); ++i) {
                int digitsDist = DistanceHelper.distanceToDigit(input.charAt(i));
                if (i == 0) {
                    distance += (long)Math.min(digitsDist, DistanceHelper.distanceToChar(input.charAt(i), '-'));
                    continue;
                }
                int firstIndexOfDot = input.substring(1).indexOf(46);
                if (firstIndexOfDot != -1) {
                    distance += (long)Math.min(digitsDist, DistanceHelper.distanceToChar(input.charAt(i), '.'));
                    continue;
                }
                if (i == firstIndexOfDot) {
                    distance += 0L;
                    continue;
                }
                distance += (long)digitsDist;
            }
        }
        return 0.1 + 0.9 / (double)(distance + 1L);
    }
}

