/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class IntegerClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Integer.class;
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true)
    public static int parseInt(String input, String idTemplate) {
        if (ExecutionTracer.isTaintInput(input)) {
            ExecutionTracer.addStringSpecialization(input, new StringSpecializationInfo(StringSpecialization.INTEGER, null));
        }
        if (idTemplate == null) {
            return Integer.parseInt(input);
        }
        try {
            int res = Integer.parseInt(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.0));
            return res;
        }
        catch (RuntimeException e) {
            double h = IntegerClassReplacement.parseIntHeuristic(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
            throw e;
        }
    }

    private static double parseIntHeuristic(String input, int maxNumberOfDigits) {
        if (maxNumberOfDigits < 0) {
            throw new IllegalArgumentException("Number of digits cannot be negative");
        }
        if (input == null) {
            return 0.05;
        }
        double base = 0.1;
        if (input.length() == 0) {
            return 0.1;
        }
        long distance = 0L;
        if (input.length() == 1) {
            distance += (long)DistanceHelper.distanceToDigit(input.charAt(0));
        } else {
            for (int i = 0; i < input.length(); ++i) {
                int digitsDist = DistanceHelper.distanceToDigit(input.charAt(i));
                if (i == 0) {
                    distance += (long)Math.min(digitsDist, DistanceHelper.distanceToChar(input.charAt(i), '-'));
                    continue;
                }
                if (i >= maxNumberOfDigits) {
                    distance += 65536L;
                    continue;
                }
                distance += (long)digitsDist;
            }
        }
        return 0.1 + 0.9 / (double)(distance + 1L);
    }

    public static double parseIntHeuristic(String input) {
        int maxNumberOfDigits = Integer.valueOf(Integer.MIN_VALUE).toString().length();
        return IntegerClassReplacement.parseIntHeuristic(input, maxNumberOfDigits);
    }

    public static double parseLongHeuristic(String input) {
        int maxNumberOfDigits = Long.valueOf(Long.MIN_VALUE).toString().length();
        return IntegerClassReplacement.parseIntHeuristic(input, maxNumberOfDigits);
    }
}

