/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.shared;

import java.util.Objects;

public class ClassName {
    private final String bytecodeName;
    private final String fullNameWithDots;

    public static ClassName get(Class<?> klass) {
        return new ClassName(klass);
    }

    public static ClassName get(String name) {
        return new ClassName(name);
    }

    public ClassName(Class<?> klass) {
        this(Objects.requireNonNull(klass).getName());
    }

    public ClassName(String name) {
        Objects.requireNonNull(name);
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        if (name.endsWith(".java")) {
            name = name.substring(0, name.length() - ".java".length());
        }
        if (name.contains("/") && name.contains(".")) {
            throw new IllegalArgumentException("Do not know how to handle name: " + name);
        }
        if (name.contains("/")) {
            this.bytecodeName = name;
            this.fullNameWithDots = name.replace("/", ".");
        } else {
            this.bytecodeName = name.replace(".", "/");
            this.fullNameWithDots = name;
        }
    }

    public String getBytecodeName() {
        return this.bytecodeName;
    }

    public String getFullNameWithDots() {
        return this.fullNameWithDots;
    }

    public String getAsResourcePath() {
        return this.bytecodeName + ".class";
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.fullNameWithDots + "]";
    }
}

