/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ReplacementList;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ObjectiveNaming;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.org.objectweb.asm.Label;
import shaded.org.objectweb.asm.MethodVisitor;
import shaded.org.objectweb.asm.Type;

public class MethodReplacementMethodVisitor
extends MethodVisitor {
    private final String className;
    private final String methodName;
    private final boolean registerNewTargets;
    private int currentLine;
    private int currentIndex;

    public MethodReplacementMethodVisitor(boolean registerNewTargets, MethodVisitor mv, String className, String methodName, String descriptor) {
        super(458752, mv);
        this.className = className;
        this.methodName = methodName;
        this.registerNewTargets = registerNewTargets;
        this.currentLine = 0;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
        this.currentIndex = 0;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.methodName.equals("<clinit>")) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        if (!owner.startsWith("java/")) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        if (opcode == 183) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        Class<?> klass = null;
        try {
            klass = this.getClass().getClassLoader().loadClass(ClassName.get(owner).getFullNameWithDots());
        }
        catch (ClassNotFoundException e) {
            SimpleLogger.error(e.toString());
            throw new RuntimeException(e);
        }
        List<MethodReplacementClass> candidateClasses = ReplacementList.getReplacements(klass);
        if (candidateClasses.isEmpty()) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        Optional<Method> r = candidateClasses.stream().flatMap(i -> Stream.of(i.getClass().getDeclaredMethods())).filter(m -> m.getDeclaredAnnotation(Replacement.class) != null).filter(m -> m.getName().equals(name)).filter(m -> {
            Replacement br = m.getAnnotation(Replacement.class);
            return br.replacingStatic() && desc.equals(MethodReplacementMethodVisitor.getDescriptorSkippingLast(m, 0)) || !br.replacingStatic() && desc.equals(MethodReplacementMethodVisitor.getDescriptorSkippingLast(m, 1));
        }).findAny();
        if (!r.isPresent()) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        Method m2 = r.get();
        this.replaceMethod(m2);
        if (this.registerNewTargets) {
            UnitsInfoRecorder.markNewReplacedMethodInSut();
        } else {
            UnitsInfoRecorder.markNewReplacedMethodInThirdParty();
        }
    }

    private void replaceMethod(Method m) {
        Replacement br = m.getAnnotation(Replacement.class);
        if (this.registerNewTargets) {
            String idTemplate = ObjectiveNaming.methodReplacementObjectiveNameTemplate(this.className, this.currentLine, this.currentIndex);
            ++this.currentIndex;
            String idTrue = ObjectiveNaming.methodReplacementObjectiveName(idTemplate, true, br.type());
            String idFalse = ObjectiveNaming.methodReplacementObjectiveName(idTemplate, false, br.type());
            ObjectiveRecorder.registerTarget(idTrue);
            ObjectiveRecorder.registerTarget(idFalse);
            this.visitLdcInsn(idTemplate);
        } else {
            this.visitInsn(1);
        }
        this.mv.visitMethodInsn(184, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m), false);
    }

    private static String getDescriptorSkippingLast(Method m, int skipFirsts) {
        int start;
        Class<?>[] parameters = m.getParameterTypes();
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (int i = start = skipFirsts; i < parameters.length - 1; ++i) {
            buf.append(Type.getDescriptor(parameters[i]));
        }
        buf.append(')');
        buf.append(Type.getDescriptor(m.getReturnType()));
        return buf.toString();
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack + 1, maxLocals);
    }
}

