/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DateTimeParsingUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.heuristic.TruthnessUtils;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class LocalDateTimeClassReplacement
implements MethodReplacementClass {
    private static long getMillis(ChronoLocalDateTime<?> chronoLocalDateTime) {
        return chronoLocalDateTime.atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
    }

    private static Truthness getIsBeforeTruthness(ChronoLocalDateTime<?> caller, ChronoLocalDateTime<?> when) {
        Objects.requireNonNull(caller);
        Objects.requireNonNull(when);
        long a = LocalDateTimeClassReplacement.getMillis(caller);
        long b = LocalDateTimeClassReplacement.getMillis(when);
        return TruthnessUtils.getLessThanTruthness(a, b);
    }

    @Override
    public Class<?> getTargetClass() {
        return LocalDateTime.class;
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true)
    public static LocalDateTime parse(CharSequence text, String idTemplate) {
        if (text != null && ExecutionTracer.isTaintInput(text.toString())) {
            ExecutionTracer.addStringSpecialization(text.toString(), new StringSpecializationInfo(StringSpecialization.ISO_LOCAL_DATE_TIME, null));
        }
        if (idTemplate == null) {
            return LocalDateTime.parse(text);
        }
        try {
            LocalDateTime res = LocalDateTime.parse(text);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.0));
            return res;
        }
        catch (NullPointerException | DateTimeParseException ex) {
            double h = DateTimeParsingUtils.getHeuristicToISOLocalDateTimeParsing(text);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
            throw ex;
        }
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean equals(LocalDateTime caller, Object anObject, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.equals(anObject);
        }
        if (anObject == null || !(anObject instanceof LocalDateTime)) {
            t = new Truthness(0.05, 1.0);
        } else {
            LocalDateTime anotherLocalDateTime = (LocalDateTime)anObject;
            if (caller.equals(anotherLocalDateTime)) {
                t = new Truthness(1.0, 0.0);
            } else {
                double base = 0.1;
                double distance = DistanceHelper.getDistanceToEquality(caller, anotherLocalDateTime);
                double h = base + (1.0 - base) / (1.0 + distance);
                t = new Truthness(h, 1.0);
            }
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.equals(anObject);
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean isBefore(LocalDateTime caller, ChronoLocalDateTime<?> other, String idTemplate) {
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.isBefore(other);
        }
        Truthness t = other == null ? new Truthness(0.05, 1.0) : LocalDateTimeClassReplacement.getIsBeforeTruthness(caller, other);
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.isBefore(other);
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean isAfter(LocalDateTime caller, ChronoLocalDateTime<?> other, String idTemplate) {
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.isAfter(other);
        }
        Truthness t = other == null ? new Truthness(0.05, 1.0) : LocalDateTimeClassReplacement.getIsBeforeTruthness(other, caller);
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.isAfter(other);
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean isEqual(LocalDateTime caller, ChronoLocalDateTime<?> other, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.isEqual(other);
        }
        if (other == null) {
            t = new Truthness(0.05, 1.0);
        } else if (caller.isEqual(other)) {
            t = new Truthness(1.0, 0.0);
        } else {
            double base = 0.1;
            double distance = DistanceHelper.getDistanceToEquality(caller, other);
            double h = base + (1.0 - base) / (1.0 + distance);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.isEqual(other);
    }
}

