/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class WebRequestClassReplacement
extends ThirdPartyMethodReplacementClass {
    private static final WebRequestClassReplacement singleton = new WebRequestClassReplacement();

    @Override
    protected String getNameOfThirdPartyTargetClass() {
        return "org.springframework.web.context.request.WebRequest";
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="getParameter", usageFilter=UsageFilter.ONLY_SUT)
    public static String getParameter(Object caller, String param) {
        ExecutionTracer.addQueryParameter(param);
        Method original = WebRequestClassReplacement.getOriginal(singleton, "getParameter");
        try {
            return (String)original.invoke(caller, param);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="getParameterValues", usageFilter=UsageFilter.ONLY_SUT)
    public static String[] getParameterValues(Object caller, String param) {
        ExecutionTracer.addQueryParameter(param);
        Method original = WebRequestClassReplacement.getOriginal(singleton, "getParameterValues");
        try {
            return (String[])original.invoke(caller, param);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="getHeader", usageFilter=UsageFilter.ONLY_SUT)
    public static String getHeader(Object caller, String header) {
        ExecutionTracer.addHeader(header);
        Method original = WebRequestClassReplacement.getOriginal(singleton, "getHeader");
        try {
            return (String)original.invoke(caller, header);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="getHeaderValues", usageFilter=UsageFilter.ONLY_SUT)
    public static String[] getHeaderValues(Object caller, String header) {
        ExecutionTracer.addHeader(header);
        Method original = WebRequestClassReplacement.getOriginal(singleton, "getHeaderValues");
        try {
            return (String[])original.invoke(caller, header);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

