/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.PatternMatchingHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.heuristic.TruthnessUtils;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class StringClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return String.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean equals(String caller, Object anObject, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        String left = caller;
        String right = anObject == null ? null : anObject.toString();
        ExecutionTracer.handleTaintForStringEquals(left, right, false);
        boolean result = caller.equals(anObject);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.0);
        } else if (!(anObject instanceof String)) {
            t = new Truthness(0.0, 1.0);
        } else {
            long distance = DistanceHelper.getLeftAlignmentDistance(caller, anObject.toString());
            t = new Truthness(1.0 / (1.0 + (double)distance), 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean equalsIgnoreCase(String caller, String anotherString, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        ExecutionTracer.handleTaintForStringEquals(caller, anotherString, true);
        boolean result = caller.equalsIgnoreCase(anotherString);
        if (idTemplate == null) {
            return result;
        }
        if (anotherString == null) {
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, new Truthness(0.0, 1.0));
            return false;
        }
        if (result) {
            t = new Truthness(1.0, 0.0);
        } else {
            long distance = DistanceHelper.getLeftAlignmentDistance(caller.toLowerCase(), anotherString.toLowerCase());
            t = new Truthness(1.0 / (1.0 + (double)distance), 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean startsWith(String caller, String prefix, int toffset, String idTemplate) {
        Truthness t;
        int pl;
        Objects.requireNonNull(caller);
        boolean result = caller.startsWith(prefix, toffset);
        if (idTemplate == null) {
            return result;
        }
        int penalty = pl = prefix.length();
        if (caller.length() < pl) {
            penalty += pl - caller.length();
        }
        if (toffset < 0) {
            long dist = (-toffset + penalty) * 65535;
            t = new Truthness(1.0 / (1.0 + (double)dist), 1.0);
        } else if (toffset > caller.length() - pl) {
            long dist = (toffset + penalty) * 65535;
            t = new Truthness(1.0 / (1.0 + (double)dist), 1.0);
        } else {
            int len = Math.min(prefix.length(), caller.length());
            String sub = caller.substring(toffset, Math.min(toffset + len, caller.length()));
            return StringClassReplacement.equals(sub, prefix, idTemplate);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean startsWith(String caller, String prefix, String idTemplate) {
        Objects.requireNonNull(caller);
        return StringClassReplacement.startsWith(caller, prefix, 0, idTemplate);
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean endsWith(String caller, String suffix, String idTemplate) {
        Objects.requireNonNull(caller);
        return StringClassReplacement.startsWith(caller, suffix, caller.length() - suffix.length(), idTemplate);
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean isEmpty(String caller, String idTemplate) {
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.isEmpty();
        }
        int len = caller.length();
        Truthness t = TruthnessUtils.getTruthnessToEmpty(len);
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.isEmpty();
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean contentEquals(String caller, CharSequence cs, String idTemplate) {
        if (cs == null) {
            return caller.contentEquals(cs);
        }
        return StringClassReplacement.equals(caller, cs.toString(), idTemplate);
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean contentEquals(String caller, StringBuffer sb, String idTemplate) {
        return StringClassReplacement.equals(caller, sb.toString(), idTemplate);
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean contains(String caller, CharSequence s, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        boolean result = caller.contains(s);
        if (idTemplate == null) {
            return result;
        }
        String k = s.toString();
        if (caller.length() <= k.length()) {
            return StringClassReplacement.equals(caller, k, idTemplate);
        }
        if (result) {
            t = new Truthness(1.0, 0.0);
        } else {
            assert (caller.length() > k.length());
            long best = Long.MAX_VALUE;
            for (int i = 0; i < caller.length() - k.length() + 1; ++i) {
                String sub = caller.substring(i, i + k.length());
                long h = DistanceHelper.getLeftAlignmentDistance(sub, k);
                if (h >= best) continue;
                best = h;
            }
            t = new Truthness(1.0 / (1.0 + (double)best), 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean matches(String caller, String regex, String idTemplate) {
        Objects.requireNonNull(caller);
        if (regex == null) {
            return caller.matches(regex);
        }
        return PatternMatchingHelper.matches(regex, caller, idTemplate);
    }
}

