/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.schema.DatabaseType;
import org.evomaster.client.java.controller.db.DbUnsupportedException;
import org.evomaster.client.java.utils.SimpleLogger;

public class DbCleaner {
    public static void clearDatabase_H2(Connection connection) {
        DbCleaner.clearDatabase_H2(connection, null);
    }

    public static void clearDatabase_H2(Connection connection, List<String> tableToSkip) {
        DbCleaner.clearDatabase_H2(connection, DbCleaner.getDefaultSchema(DatabaseType.H2), tableToSkip);
    }

    public static void clearDatabase_H2(Connection connection, String schemaName, List<String> tableToSkip) {
        DbCleaner.clearDatabase_H2(connection, schemaName, tableToSkip, null);
    }

    public static void clearDatabase_H2(Connection connection, String schemaName, List<String> tableToSkip, List<String> tableToClean) {
        DbCleaner.clearDatabase(DbCleaner.getDefaultReties(DatabaseType.H2), connection, schemaName, tableToSkip, tableToClean, DatabaseType.H2, false);
    }

    private static void clearDatabase(int retries, Connection connection, String schemaName, List<String> tableToSkip, List<String> tableToClean, DatabaseType type, boolean doDropTable) {
        try {
            Statement statement = connection.createStatement();
            DbCleaner.disableReferentialIntegrity(statement, type);
            DbCleaner.cleanDataInTables(tableToSkip, tableToClean, statement, type, schemaName, DbCleaner.isSingleCleanCommand(type), doDropTable);
            DbCleaner.resetSequences(statement, type, schemaName);
            DbCleaner.enableReferentialIntegrity(statement, type);
            statement.close();
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.toLowerCase().contains("timeout")) {
                if (retries > 0) {
                    SimpleLogger.warn("Timeout issue with cleaning DB. Trying again.");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    DbCleaner.clearDatabase(--retries, connection, schemaName, tableToSkip, tableToClean, type, doDropTable);
                } else {
                    SimpleLogger.error("Giving up cleaning the DB. There are still timeouts.");
                }
            }
            throw new RuntimeException(e);
        }
    }

    public static void clearDatabase(Connection connection, List<String> tablesToSkip, DatabaseType type) {
        DbCleaner.clearDatabase(connection, DbCleaner.getDefaultSchema(type), tablesToSkip, type);
    }

    public static void clearDatabase(Connection connection, List<String> tableToSkip, List<String> tableToClean, DatabaseType type) {
        DbCleaner.clearDatabase(connection, DbCleaner.getDefaultSchema(type), tableToSkip, tableToClean, type);
    }

    public static void clearDatabase(Connection connection, String schemaName, List<String> tablesToSkip, DatabaseType type) {
        DbCleaner.clearDatabase(connection, schemaName, tablesToSkip, null, type);
    }

    public static void clearDatabase(Connection connection, String schemaName, List<String> tableToSkip, List<String> tableToClean, DatabaseType type) {
        DbCleaner.clearDatabase(DbCleaner.getDefaultReties(type), connection, schemaName, tableToSkip, tableToClean, type, false);
    }

    public static void dropDatabaseTables(Connection connection, String schemaName, List<String> tablesToSkip, DatabaseType type) {
        if (type != DatabaseType.MYSQL && type != DatabaseType.MARIADB) {
            throw new IllegalArgumentException("Dropping tables are not supported by " + (Object)((Object)type));
        }
        DbCleaner.clearDatabase(DbCleaner.getDefaultReties(type), connection, schemaName, tablesToSkip, null, type, true);
    }

    public static void clearDatabase_Postgres(Connection connection, String schemaName, List<String> tablesToSkip) {
        DbCleaner.clearDatabase_Postgres(connection, schemaName, tablesToSkip, null);
    }

    public static void clearDatabase_Postgres(Connection connection, String schemaName, List<String> tableToSkip, List<String> tableToClean) {
        DbCleaner.clearDatabase(DbCleaner.getDefaultReties(DatabaseType.POSTGRES), connection, schemaName, tableToSkip, tableToClean, DatabaseType.POSTGRES, false);
    }

    private static void cleanDataInTables(List<String> tableToSkip, List<String> tableToClean, Statement statement, DatabaseType type, String schema, boolean singleCommand, boolean doDropTable) throws SQLException {
        if (tableToSkip != null && !tableToSkip.isEmpty() && tableToClean != null && !tableToClean.isEmpty()) {
            throw new IllegalArgumentException("tableToSkip and tableToClean cannot be configured at the same time.");
        }
        HashSet<String> tables = new HashSet<String>();
        ResultSet rs = statement.executeQuery(DbCleaner.getAllTableCommand(type, schema));
        while (rs.next()) {
            tables.add(rs.getString(1));
        }
        rs.close();
        if (tables.isEmpty()) {
            throw new IllegalStateException("Could not find any table");
        }
        boolean toskip = tableToSkip != null;
        List<String> tableToHandle = tableToClean != null ? tableToClean : tableToSkip;
        if (tableToHandle != null) {
            for (String skip : tableToHandle) {
                if (tables.stream().anyMatch(t -> t.equalsIgnoreCase(skip))) continue;
                String msg = "Asked to skip/clean table '" + skip + "', but it does not exist.";
                msg = msg + " Existing tables in schema '" + schema + "': [" + tables.stream().collect(Collectors.joining(", ")) + "]";
                throw new IllegalStateException(msg);
            }
        }
        HashSet<String> tablesHaveIdentifies = new HashSet<String>();
        if (type == DatabaseType.MS_SQL_SERVER) {
            ResultSet rst = statement.executeQuery(DbCleaner.getAllTableHasIdentify(type, schema));
            while (rst.next()) {
                tablesHaveIdentifies.add(rst.getString(1));
            }
            rst.close();
        }
        List tablesToClear = tables.stream().filter(n -> tableToHandle == null || toskip && (tableToHandle.isEmpty() || tableToHandle.stream().noneMatch(skip -> skip.equalsIgnoreCase((String)n))) || !toskip && tableToHandle.stream().anyMatch(clean -> clean.equalsIgnoreCase((String)n))).collect(Collectors.toList());
        if (singleCommand) {
            String ts = tablesToClear.stream().sorted().collect(Collectors.joining(","));
            if (type != DatabaseType.POSTGRES) {
                throw new IllegalArgumentException("do not support for cleaning all data by one single command for " + (Object)((Object)type));
            }
            if (doDropTable) {
                DbCleaner.dropTables(statement, ts);
            } else {
                statement.executeUpdate("TRUNCATE TABLE " + ts);
            }
        } else {
            for (String t2 : tablesToClear) {
                if (doDropTable) {
                    DbCleaner.dropTables(statement, t2);
                    continue;
                }
                if (type == DatabaseType.MS_SQL_SERVER) {
                    DbCleaner.deleteTables(statement, t2, tablesHaveIdentifies);
                    continue;
                }
                DbCleaner.truncateTables(statement, t2);
            }
        }
    }

    private static void dropTables(Statement statement, String table) throws SQLException {
        statement.executeUpdate("DROP TABLE IF EXISTS " + table);
    }

    private static void deleteTables(Statement statement, String table, Set<String> tableHasIdentify) throws SQLException {
        statement.executeUpdate("DELETE FROM " + table);
        if (tableHasIdentify.contains(table)) {
            statement.executeUpdate("DBCC CHECKIDENT ('" + table + "', RESEED, 0)");
        }
    }

    private static void truncateTables(Statement statement, String table) throws SQLException {
        statement.executeUpdate("TRUNCATE TABLE " + table);
    }

    private static void resetSequences(Statement s, DatabaseType type, String schemaName) throws SQLException {
        HashSet<String> sequences = new HashSet<String>();
        ResultSet rs = s.executeQuery(DbCleaner.getAllSequenceCommand(type, schemaName));
        while (rs.next()) {
            sequences.add(rs.getString(1));
        }
        rs.close();
        for (String seq : sequences) {
            s.executeUpdate(DbCleaner.resetSequenceCommand(seq, type));
        }
    }

    private static void disableReferentialIntegrity(Statement s, DatabaseType type) throws SQLException {
        switch (type) {
            case POSTGRES: {
                break;
            }
            case MS_SQL_SERVER: {
                s.execute("EXEC sp_MSForEachTable \"ALTER TABLE ? NOCHECK CONSTRAINT all\"");
                break;
            }
            case H2: {
                s.execute("SET REFERENTIAL_INTEGRITY FALSE");
                break;
            }
            case MARIADB: 
            case MYSQL: {
                s.execute("SET @@foreign_key_checks = 0;");
                break;
            }
            case OTHER: {
                throw new DbUnsupportedException(type);
            }
        }
    }

    private static void enableReferentialIntegrity(Statement s, DatabaseType type) throws SQLException {
        switch (type) {
            case POSTGRES: {
                break;
            }
            case MS_SQL_SERVER: {
                s.execute("exec sp_MSForEachTable \"ALTER TABLE ? WITH CHECK CHECK CONSTRAINT all\"");
                break;
            }
            case H2: {
                s.execute("SET REFERENTIAL_INTEGRITY TRUE");
                break;
            }
            case MARIADB: 
            case MYSQL: {
                s.execute("SET @@foreign_key_checks = 1;");
                break;
            }
            case OTHER: {
                throw new DbUnsupportedException(type);
            }
        }
    }

    private static int getDefaultReties(DatabaseType type) {
        switch (type) {
            case POSTGRES: 
            case MS_SQL_SERVER: {
                return 0;
            }
            case H2: 
            case MARIADB: 
            case MYSQL: {
                return 3;
            }
        }
        throw new DbUnsupportedException(type);
    }

    private static String getDefaultSchema(DatabaseType type) {
        switch (type) {
            case H2: {
                return "PUBLIC";
            }
            case MS_SQL_SERVER: {
                return "dbo";
            }
            case MARIADB: 
            case MYSQL: {
                throw new IllegalArgumentException("there is no default schema for " + (Object)((Object)type) + ", and you must specify a db name here");
            }
            case POSTGRES: {
                return "public";
            }
        }
        throw new DbUnsupportedException(type);
    }

    private static boolean isSingleCleanCommand(DatabaseType type) {
        return type == DatabaseType.POSTGRES;
    }

    private static String getAllTableHasIdentify(DatabaseType type, String schema) {
        if (type != DatabaseType.MS_SQL_SERVER) {
            throw new IllegalArgumentException("getAllTableHasIdentify only supports for MS_SQL_SERVER, not for " + (Object)((Object)type));
        }
        return DbCleaner.getAllTableCommand(type, schema) + " AND OBJECTPROPERTY(OBJECT_ID(TABLE_NAME), 'TableHasIdentity') = 1";
    }

    private static String getAllTableCommand(DatabaseType type, String schema) {
        String command = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES where (TABLE_TYPE='TABLE' OR TABLE_TYPE='BASE TABLE')";
        switch (type) {
            case POSTGRES: 
            case MS_SQL_SERVER: 
            case H2: 
            case MARIADB: 
            case MYSQL: {
                if (schema.isEmpty()) {
                    return command;
                }
                return command + " AND TABLE_SCHEMA='" + schema + "'";
            }
        }
        throw new DbUnsupportedException(type);
    }

    private static String getAllSequenceCommand(DatabaseType type, String schemaName) {
        String command = "SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES";
        switch (type) {
            case MARIADB: 
            case MYSQL: {
                return DbCleaner.getAllTableCommand(type, schemaName);
            }
            case POSTGRES: 
            case MS_SQL_SERVER: 
            case H2: {
                if (schemaName.isEmpty()) {
                    return command;
                }
                return command + " WHERE SEQUENCE_SCHEMA='" + schemaName + "'";
            }
        }
        throw new DbUnsupportedException(type);
    }

    private static String resetSequenceCommand(String sequence, DatabaseType type) {
        switch (type) {
            case MARIADB: 
            case MYSQL: {
                return "ALTER TABLE " + sequence + " AUTO_INCREMENT=1;";
            }
            case POSTGRES: 
            case MS_SQL_SERVER: 
            case H2: {
                return "ALTER SEQUENCE " + sequence + " RESTART WITH 1";
            }
        }
        throw new DbUnsupportedException(type);
    }
}

