/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import shaded.net.sf.jsqlparser.expression.Alias;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.delete.Delete;
import shaded.net.sf.jsqlparser.statement.select.FromItem;
import shaded.net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import shaded.net.sf.jsqlparser.statement.select.Join;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.select.SelectBody;
import shaded.net.sf.jsqlparser.statement.select.SubSelect;
import shaded.net.sf.jsqlparser.statement.update.Update;

public class SqlNameContext {
    private final DbSchemaDto schema;
    private final Map<String, String> tableAliases = new HashMap<String, String>();
    private final Statement statement;
    public static final String UNNAMED_TABLE = "___unnamed_table___";

    public SqlNameContext(Statement statement) {
        this.schema = null;
        this.statement = Objects.requireNonNull(statement);
        this.computeAliases();
    }

    public SqlNameContext(Statement statement, DbSchemaDto schema) {
        this.schema = Objects.requireNonNull(schema);
        this.statement = Objects.requireNonNull(statement);
        this.computeAliases();
    }

    public String getTableName(Column column) {
        Table table = column.getTable();
        if (table != null) {
            return this.tableAliases.getOrDefault(table.getName(), table.getName());
        }
        if (this.statement instanceof Select) {
            List<String> candidates = this.getTableNamesInFrom();
            assert (!candidates.isEmpty());
            if (candidates.size() == 1) {
                return candidates.get(0);
            }
            throw new IllegalArgumentException("TODO ambiguity");
        }
        if (this.statement instanceof Delete) {
            Delete delete = (Delete)this.statement;
            return delete.getTable().getName();
        }
        if (this.statement instanceof Update) {
            Update update = (Update)this.statement;
            return update.getTable().getName();
        }
        throw new IllegalArgumentException("Cannot handle table name for: " + this.statement);
    }

    private List<String> getTableNamesInFrom() {
        FromItem fromItem = this.getFromItem();
        final ArrayList<String> names = new ArrayList<String>();
        FromItemVisitorAdapter visitor = new FromItemVisitorAdapter(){

            @Override
            public void visit(Table table) {
                names.add(table.getName());
            }
        };
        fromItem.accept(visitor);
        return names;
    }

    private FromItem getFromItem() {
        FromItem fromItem = null;
        if (this.statement instanceof Select) {
            SelectBody selectBody = ((Select)this.statement).getSelectBody();
            if (selectBody instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)selectBody;
                fromItem = plainSelect.getFromItem();
            } else {
                throw new IllegalArgumentException("Currently only handling Plain SELECTs");
            }
        }
        if (fromItem == null) {
            throw new IllegalArgumentException("Cannot handle FromItem for: " + this.statement);
        }
        return fromItem;
    }

    private void computeAliases() {
        if (this.statement instanceof Select) {
            FromItem fromItem = this.getFromItem();
            fromItem.accept(new AliasVisitor(this.tableAliases));
            SelectBody selectBody = ((Select)this.statement).getSelectBody();
            PlainSelect plainSelect = (PlainSelect)selectBody;
            List<Join> joins = plainSelect.getJoins();
            if (joins != null) {
                joins.forEach(j -> j.getRightItem().accept(new AliasVisitor(this.tableAliases)));
            }
        } else {
            if (this.statement instanceof Delete) {
                return;
            }
            if (this.statement instanceof Update) {
                return;
            }
        }
    }

    private static void handleAlias(Map<String, String> aliases, SubSelect subSelect) {
        String aliasName;
        Alias alias = subSelect.getAlias();
        if (alias != null && (aliasName = alias.getName()) != null) {
            String tableName = UNNAMED_TABLE;
            aliases.put(aliasName.trim().toLowerCase(), tableName.trim().toLowerCase());
        }
    }

    private static void handleAlias(Map<String, String> aliases, Table table) {
        String aliasName;
        Alias alias = table.getAlias();
        if (alias != null && (aliasName = alias.getName()) != null) {
            String tableName = table.getName();
            aliases.put(aliasName.trim().toLowerCase(), tableName.trim().toLowerCase());
        }
    }

    private static class AliasVisitor
    extends FromItemVisitorAdapter {
        private final Map<String, String> aliases;

        private AliasVisitor(Map<String, String> aliases) {
            this.aliases = aliases;
        }

        @Override
        public void visit(Table table) {
            SqlNameContext.handleAlias((Map<String, String>)this.aliases, table);
        }

        @Override
        public void visit(SubSelect subSelect) {
            SqlNameContext.handleAlias((Map<String, String>)this.aliases, subSelect);
        }
    }
}

