/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.NumberParsingUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class ByteClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Byte.class;
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true)
    public static byte parseByte(String input, String idTemplate) {
        if (ExecutionTracer.isTaintInput(input)) {
            ExecutionTracer.addStringSpecialization(input, new StringSpecializationInfo(StringSpecialization.INTEGER, null));
        }
        if (idTemplate == null) {
            return Byte.parseByte(input);
        }
        try {
            byte res = Byte.parseByte(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.1));
            return res;
        }
        catch (RuntimeException e) {
            double h = NumberParsingUtils.parseByteHeuristic(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
            throw e;
        }
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean equals(Byte caller, Object anObject, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.equals(anObject);
        }
        if (anObject == null || !(anObject instanceof Byte)) {
            t = new Truthness(0.05, 1.0);
        } else {
            Byte anotherByte = (Byte)anObject;
            if (caller.equals(anotherByte)) {
                t = new Truthness(1.0, 0.1);
            } else {
                double base = 0.1;
                double distance = DistanceHelper.getDistanceToEquality(caller.byteValue(), anotherByte.byteValue());
                double h = DistanceHelper.heuristicFromScaledDistanceWithBase(base, distance);
                t = new Truthness(h, 1.0);
            }
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.equals(anObject);
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true)
    public static byte valueOf(String input, String idTemplate) {
        return ByteClassReplacement.parseByte(input, idTemplate);
    }
}

