/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DateTimeParsingUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.LocalDateTimeClassReplacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class LocalTimeClassReplacement
implements MethodReplacementClass {
    private static final LocalDate LOCAL_DATE = LocalDate.of(1970, 1, 1);

    private static LocalDateTime toLocalDateTime(LocalTime localTime) {
        Objects.requireNonNull(localTime);
        return localTime.atDate(LOCAL_DATE);
    }

    @Override
    public Class<?> getTargetClass() {
        return LocalTime.class;
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true)
    public static LocalTime parse(CharSequence input, String idTemplate) {
        if (input != null && ExecutionTracer.isTaintInput(input.toString())) {
            ExecutionTracer.addStringSpecialization(input.toString(), new StringSpecializationInfo(StringSpecialization.ISO_LOCAL_TIME, null));
        }
        if (idTemplate == null) {
            return LocalTime.parse(input);
        }
        try {
            LocalTime res = LocalTime.parse(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.1));
            return res;
        }
        catch (NullPointerException | DateTimeParseException e) {
            double h = DateTimeParsingUtils.getHeuristicToISOLocalTimeParsing(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
            throw e;
        }
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean equals(LocalTime caller, Object anObject, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.equals(anObject);
        }
        if (anObject == null || !(anObject instanceof LocalTime)) {
            t = new Truthness(0.05, 1.0);
        } else {
            LocalTime anotherLocalTime = (LocalTime)anObject;
            if (caller.equals(anotherLocalTime)) {
                t = new Truthness(1.0, 0.1);
            } else {
                double base = 0.1;
                double distance = DistanceHelper.getDistanceToEquality(caller, anotherLocalTime);
                double h = DistanceHelper.heuristicFromScaledDistanceWithBase(base, distance);
                t = new Truthness(h, 1.0);
            }
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.equals(anObject);
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean isBefore(LocalTime caller, LocalTime when, String idTemplate) {
        Objects.requireNonNull(caller);
        return LocalDateTimeClassReplacement.isBefore(LocalTimeClassReplacement.toLocalDateTime(caller), when == null ? null : LocalTimeClassReplacement.toLocalDateTime(when), idTemplate);
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean isAfter(LocalTime caller, LocalTime when, String idTemplate) {
        Objects.requireNonNull(caller);
        return LocalDateTimeClassReplacement.isAfter(LocalTimeClassReplacement.toLocalDateTime(caller), when == null ? null : LocalTimeClassReplacement.toLocalDateTime(when), idTemplate);
    }
}

