/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.db;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.operations.QueryResultDto;
import org.evomaster.client.java.controller.db.DataRow;
import org.evomaster.client.java.controller.db.VariableDescriptor;

public class QueryResult {
    private final List<VariableDescriptor> variableDescriptors = new ArrayList<VariableDescriptor>();
    private final List<DataRow> rows = new ArrayList<DataRow>();

    public QueryResult(List<String> columnNames, String tableName) {
        Objects.requireNonNull(columnNames);
        for (String c : columnNames) {
            this.variableDescriptors.add(new VariableDescriptor(c, null, tableName));
        }
    }

    private String getColumnName(ResultSetMetaData md, int index) throws Exception {
        if (Arrays.stream(md.getClass().getInterfaces()).anyMatch(i -> i.getSimpleName().equals("PGResultSetMetaData"))) {
            Method m = md.getClass().getDeclaredMethod("getBaseColumnName", Integer.TYPE);
            return (String)m.invoke((Object)md, index);
        }
        return md.getColumnName(index);
    }

    public QueryResult(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            ResultSetMetaData md = resultSet.getMetaData();
            for (int i = 0; i < md.getColumnCount(); ++i) {
                int index = i + 1;
                VariableDescriptor desc = new VariableDescriptor(this.getColumnName(md, index), md.getColumnLabel(index), md.getTableName(index));
                this.variableDescriptors.add(desc);
            }
            while (resultSet.next()) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 0; i < md.getColumnCount(); ++i) {
                    Object value = resultSet.getObject(i + 1);
                    row.add(value);
                }
                this.rows.add(new DataRow(this.variableDescriptors, row));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addRow(DataRow row) {
        if (!this.sameVariableNames(row)) {
            throw new IllegalArgumentException("Variable name mismatch");
        }
        this.rows.add(row);
    }

    public boolean sameVariableNames(DataRow row) {
        if (this.variableDescriptors.size() != row.getVariableDescriptors().size()) {
            return false;
        }
        for (int i = 0; i < this.variableDescriptors.size(); ++i) {
            VariableDescriptor b;
            VariableDescriptor a = this.variableDescriptors.get(i);
            if (a.equals(b = row.getVariableDescriptors().get(i))) continue;
            return false;
        }
        return true;
    }

    public List<DataRow> seeRows() {
        return this.rows;
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public int size() {
        return this.rows.size();
    }

    public String toString() {
        if (this.variableDescriptors.isEmpty()) {
            return "EMPTY";
        }
        String header = this.variableDescriptors.stream().map(d -> d.toString()).collect(Collectors.joining(","));
        return header + this.rows.stream().map(r -> "\n" + r.getAsLine()).collect(Collectors.joining());
    }

    public QueryResultDto toDto() {
        QueryResultDto dto = new QueryResultDto();
        dto.rows = this.rows.stream().map(r -> r.toDto()).collect(Collectors.toList());
        return dto;
    }
}

