/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import org.evomaster.client.java.controller.CustomizationHandler;
import org.evomaster.client.java.controller.SutHandler;
import org.evomaster.client.java.controller.api.dto.ActionDto;
import org.evomaster.client.java.controller.api.dto.ActionResponseDto;
import org.evomaster.client.java.controller.api.dto.AuthenticationDto;
import org.evomaster.client.java.controller.api.dto.BootTimeInfoDto;
import org.evomaster.client.java.controller.api.dto.CustomizedCallResultCode;
import org.evomaster.client.java.controller.api.dto.CustomizedRequestValueDto;
import org.evomaster.client.java.controller.api.dto.ExternalServiceInfoDto;
import org.evomaster.client.java.controller.api.dto.ExtraHeuristicsDto;
import org.evomaster.client.java.controller.api.dto.HeuristicEntryDto;
import org.evomaster.client.java.controller.api.dto.SutInfoDto;
import org.evomaster.client.java.controller.api.dto.TargetInfoDto;
import org.evomaster.client.java.controller.api.dto.UnitsInfoDto;
import org.evomaster.client.java.controller.api.dto.database.execution.ExecutionDto;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionDto;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionResultsDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCActionDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCType;
import org.evomaster.client.java.controller.api.dto.problem.rpc.SeededRPCActionDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.SeededRPCTestDto;
import org.evomaster.client.java.controller.db.DbCleaner;
import org.evomaster.client.java.controller.db.SqlScriptRunner;
import org.evomaster.client.java.controller.db.SqlScriptRunnerCached;
import org.evomaster.client.java.controller.internal.EMController;
import org.evomaster.client.java.controller.internal.db.DbSpecification;
import org.evomaster.client.java.controller.internal.db.SchemaExtractor;
import org.evomaster.client.java.controller.internal.db.SqlHandler;
import org.evomaster.client.java.controller.problem.ProblemInfo;
import org.evomaster.client.java.controller.problem.RPCProblem;
import org.evomaster.client.java.controller.problem.rpc.CustomizedNotNullAnnotationForRPCDto;
import org.evomaster.client.java.controller.problem.rpc.RPCEndpointsBuilder;
import org.evomaster.client.java.controller.problem.rpc.RPCExceptionHandler;
import org.evomaster.client.java.controller.problem.rpc.schema.EndpointSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.InterfaceSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.LocalAuthSetupSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import org.evomaster.client.java.instrumentation.AdditionalInfo;
import org.evomaster.client.java.instrumentation.BootTimeObjectiveInfo;
import org.evomaster.client.java.instrumentation.SqlInfo;
import org.evomaster.client.java.instrumentation.TargetInfo;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.org.eclipse.jetty.server.AbstractNetworkConnector;
import shaded.org.eclipse.jetty.server.Server;
import shaded.org.eclipse.jetty.server.handler.ErrorHandler;
import shaded.org.eclipse.jetty.servlet.ServletContextHandler;
import shaded.org.eclipse.jetty.servlet.ServletHolder;
import shaded.org.glassfish.jersey.jackson.JacksonFeature;
import shaded.org.glassfish.jersey.logging.LoggingFeature;
import shaded.org.glassfish.jersey.server.ResourceConfig;
import shaded.org.glassfish.jersey.servlet.ServletContainer;

public abstract class SutController
implements SutHandler,
CustomizationHandler {
    private int controllerPort = 40100;
    private String controllerHost = "localhost";
    private final SqlHandler sqlHandler = new SqlHandler();
    private Server controllerServer;
    private DbSchemaDto schemaDto;
    private final List<ExtraHeuristicsDto> extras = new CopyOnWriteArrayList<ExtraHeuristicsDto>();
    private final List<String> accessedTables = new CopyOnWriteArrayList<String>();
    private final Map<String, List<String>> fkMap = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<String>> tableInitSqlMap = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, InterfaceSchema> rpcInterfaceSchema = new LinkedHashMap<String, InterfaceSchema>();
    private final Map<Integer, LocalAuthSetupSchema> localAuthSetupSchemaMap = new LinkedHashMap<Integer, LocalAuthSetupSchema>();
    private ObjectMapper objectMapper;
    private int actionIndex = -1;

    public final boolean startTheControllerServer() {
        ResourceConfig config = new ResourceConfig();
        config.register((Class)JacksonFeature.class);
        config.register(new EMController(this));
        config.register((Class)LoggingFeature.class);
        this.controllerServer = new Server(InetSocketAddress.createUnresolved(this.getControllerHost(), this.getControllerPort()));
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        this.controllerServer.setErrorHandler(errorHandler);
        ServletHolder servlet = new ServletHolder((Servlet)new ServletContainer(config));
        ServletContextHandler context = new ServletContextHandler(this.controllerServer, "/controller/api/*");
        context.addServlet(servlet, "/*");
        try {
            this.controllerServer.start();
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to start Jetty: " + e.getMessage());
            this.controllerServer.destroy();
        }
        this.newSearch();
        SimpleLogger.info("Started controller server on: " + this.controllerServer.getURI());
        return true;
    }

    public final boolean stopTheControllerServer() {
        try {
            this.controllerServer.stop();
            return true;
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to stop the controller server: " + e.toString());
            return false;
        }
    }

    public final int getControllerServerPort() {
        return ((AbstractNetworkConnector)this.controllerServer.getConnectors()[0]).getLocalPort();
    }

    public final int getControllerPort() {
        return this.controllerPort;
    }

    public final void setControllerPort(int controllerPort) {
        this.controllerPort = controllerPort;
    }

    public final String getControllerHost() {
        return this.controllerHost;
    }

    public final void setControllerHost(String controllerHost) {
        this.controllerHost = controllerHost;
    }

    @Override
    public InsertionResultsDto execInsertionsIntoDatabase(List<InsertionDto> insertions, InsertionResultsDto ... previous) {
        Connection connection = this.getConnectionIfExist();
        if (connection == null) {
            throw new IllegalStateException("No connection to database");
        }
        try {
            return SqlScriptRunner.execInsert(connection, insertions, previous);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int getActionIndex() {
        return this.actionIndex;
    }

    @Deprecated
    public final void handleSql(String sql) {
        Objects.requireNonNull(sql);
        this.sqlHandler.handle(sql);
    }

    public final void enableComputeSqlHeuristicsOrExtractExecution(boolean enableSqlHeuristics, boolean enableSqlExecution) {
        this.sqlHandler.setCalculateHeuristics(enableSqlHeuristics);
        this.sqlHandler.setExtractSqlExecution(enableSqlHeuristics || enableSqlExecution);
    }

    public final void initSqlHandler() {
        this.sqlHandler.setConnection(this.getConnectionIfExist());
        this.sqlHandler.setSchema(this.getSqlDatabaseSchema());
    }

    public final Connection getConnectionIfExist() {
        return this.getDbSpecifications() == null || this.getDbSpecifications().isEmpty() ? null : this.getDbSpecifications().get((int)0).connection;
    }

    public final boolean doEmploySmartDbClean() {
        return this.getDbSpecifications() != null && !this.getDbSpecifications().isEmpty() && this.getDbSpecifications().get((int)0).employSmartDbClean;
    }

    public final void resetExtraHeuristics() {
        this.sqlHandler.reset();
    }

    public final List<ExtraHeuristicsDto> getExtraHeuristics() {
        if (this.extras.size() == this.actionIndex) {
            this.extras.add(this.computeExtraHeuristics());
        }
        return new ArrayList<ExtraHeuristicsDto>(this.extras);
    }

    public final ExtraHeuristicsDto computeExtraHeuristics() {
        List<AdditionalInfo> list;
        ExtraHeuristicsDto dto = new ExtraHeuristicsDto();
        if ((this.sqlHandler.isCalculateHeuristics() || this.sqlHandler.isExtractSqlExecution()) && !(list = this.getAdditionalInfoList()).isEmpty()) {
            AdditionalInfo last = list.get(list.size() - 1);
            last.getSqlInfoData().stream().forEach(it -> {
                block2: {
                    try {
                        this.sqlHandler.handle((SqlInfo)it);
                    }
                    catch (Exception e) {
                        SimpleLogger.error("FAILED TO HANDLE SQL COMMAND: " + it.getCommand());
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            });
        }
        if (this.sqlHandler.isCalculateHeuristics()) {
            this.sqlHandler.getDistances().stream().map(p -> new HeuristicEntryDto(HeuristicEntryDto.Type.SQL, HeuristicEntryDto.Objective.MINIMIZE_TO_ZERO, p.sqlCommand, p.distance)).forEach(h -> dto.heuristics.add((HeuristicEntryDto)h));
        }
        if (this.sqlHandler.isCalculateHeuristics() || this.sqlHandler.isExtractSqlExecution()) {
            ExecutionDto executionDto;
            dto.databaseExecutionDto = executionDto = this.sqlHandler.getExecutionDto();
            if (executionDto != null) {
                this.accessedTables.addAll(executionDto.deletedData);
                this.accessedTables.addAll(executionDto.insertedData.keySet());
                this.accessedTables.addAll(executionDto.insertedData.keySet());
                this.accessedTables.addAll(executionDto.updatedData.keySet());
            }
        }
        return dto;
    }

    public final void cleanAccessedTables() {
        if (this.getDbSpecifications() == null || this.getDbSpecifications().isEmpty()) {
            return;
        }
        if (this.getDbSpecifications().size() > 1) {
            throw new RuntimeException("Error: DO NOT SUPPORT MULTIPLE SQL CONNECTION YET");
        }
        DbSpecification emDbClean = this.getDbSpecifications().get(0);
        if (this.getConnectionIfExist() == null || !emDbClean.employSmartDbClean) {
            return;
        }
        try {
            this.setExecutingInitSql(true);
            Set tableDataToInit = null;
            if (!this.accessedTables.isEmpty()) {
                ArrayList<String> tablesToClean = new ArrayList<String>();
                this.getTableToClean(this.accessedTables, tablesToClean);
                if (!tablesToClean.isEmpty()) {
                    if (emDbClean.schemaNames != null && !emDbClean.schemaNames.isEmpty()) {
                        emDbClean.schemaNames.forEach(sch -> DbCleaner.clearDatabase(this.getConnectionIfExist(), sch, null, tablesToClean, emDbClean.dbType));
                    } else {
                        DbCleaner.clearDatabase(this.getConnectionIfExist(), null, null, tablesToClean, emDbClean.dbType);
                    }
                    tableDataToInit = tablesToClean.stream().filter(a -> this.tableInitSqlMap.keySet().stream().anyMatch(t -> t.equalsIgnoreCase((String)a))).collect(Collectors.toSet());
                }
            }
            this.handleInitSql(tableDataToInit, emDbClean);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQL Init Execution Error: fail to execute " + e);
        }
        finally {
            this.setExecutingInitSql(false);
        }
    }

    private void handleInitSql(Collection<String> tableDataToInit, DbSpecification spec) throws SQLException {
        boolean initAll = this.initSqlScriptAndGetInsertMap(this.getConnectionIfExist(), spec);
        if (!initAll && tableDataToInit != null && !tableDataToInit.isEmpty()) {
            tableDataToInit.forEach(a -> this.tableInitSqlMap.keySet().stream().filter(t -> t.equalsIgnoreCase((String)a)).forEach(t -> this.tableInitSqlMap.get(t).forEach(c -> {
                try {
                    SqlScriptRunner.execCommand(this.getConnectionIfExist(), c);
                }
                catch (SQLException e) {
                    throw new RuntimeException("SQL Init Execution Error: fail to execute " + c + " with error " + e);
                }
            })));
        }
    }

    public void addTableToInserted(List<String> tables) {
        this.accessedTables.addAll(tables);
    }

    private void getTableToClean(List<String> accessedTables, List<String> tablesToClean) {
        for (String t : accessedTables) {
            if (this.findInCollectionIgnoreCase(t, tablesToClean).isPresent()) continue;
            if (this.findInMapIgnoreCase(t, this.fkMap).isPresent()) {
                tablesToClean.add(t);
                List<String> fk = this.fkMap.entrySet().stream().filter(e -> this.findInCollectionIgnoreCase(t, (Collection)e.getValue()).isPresent() && !this.findInCollectionIgnoreCase((String)e.getKey(), tablesToClean).isPresent()).map(Map.Entry::getKey).collect(Collectors.toList());
                if (fk.isEmpty()) continue;
                this.getTableToClean(fk, tablesToClean);
                continue;
            }
            SimpleLogger.uniqueWarn("Cannot find the table " + t + " in [" + String.join((CharSequence)",", this.fkMap.keySet()) + "]");
        }
    }

    private Optional<String> findInCollectionIgnoreCase(String name, Collection<String> list) {
        return list.stream().filter(i -> i.equalsIgnoreCase(name)).findFirst();
    }

    private Optional<? extends Map.Entry<String, ?>> findInMapIgnoreCase(String name, Map<String, ?> list) {
        return list.entrySet().stream().filter(x -> ((String)x.getKey()).equalsIgnoreCase(name)).findFirst();
    }

    private boolean initSqlScriptAndGetInsertMap(Connection connection, DbSpecification dbSpecification) throws SQLException {
        if (dbSpecification.initSqlOnResourcePath == null && dbSpecification.initSqlScript == null) {
            return false;
        }
        if (this.tableInitSqlMap.isEmpty()) {
            ArrayList<String> all = new ArrayList<String>();
            if (dbSpecification.initSqlOnResourcePath != null) {
                all.addAll(SqlScriptRunnerCached.extractSqlScriptFromResourceFile(dbSpecification.initSqlOnResourcePath));
            }
            if (dbSpecification.initSqlScript != null) {
                all.addAll(SqlScriptRunner.extractSql(dbSpecification.initSqlScript));
            }
            if (!all.isEmpty()) {
                this.tableInitSqlMap.putAll(SqlScriptRunner.extractSqlTableMap(all));
                SqlScriptRunner.runCommands(connection, all);
                return true;
            }
        }
        return false;
    }

    public final DbSchemaDto getSqlDatabaseSchema() {
        if (this.schemaDto != null) {
            return this.schemaDto;
        }
        if (this.getDbSpecifications() == null || this.getDbSpecifications().isEmpty()) {
            return null;
        }
        try {
            this.schemaDto = SchemaExtractor.extract(this.getConnectionIfExist());
            Objects.requireNonNull(this.schemaDto);
            this.schemaDto.employSmartDbClean = this.doEmploySmartDbClean();
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to extract the SQL Database Schema: " + e.getMessage(), e);
            return null;
        }
        if (this.fkMap.isEmpty()) {
            this.schemaDto.tables.forEach(t -> {
                this.fkMap.putIfAbsent(t.name, new ArrayList());
                if (t.foreignKeys != null && !t.foreignKeys.isEmpty()) {
                    t.foreignKeys.forEach(f -> this.fkMap.get(t.name).add(f.targetTable.toUpperCase()));
                }
            });
        }
        return this.schemaDto;
    }

    public final Map<String, InterfaceSchema> getRPCSchema() {
        return this.rpcInterfaceSchema;
    }

    public Map<Integer, LocalAuthSetupSchema> getLocalAuthSetupSchemaMap() {
        return this.localAuthSetupSchemaMap;
    }

    @Override
    public final void extractRPCSchema() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        if (!this.rpcInterfaceSchema.isEmpty()) {
            return;
        }
        if (!(this.getProblemInfo() instanceof RPCProblem)) {
            SimpleLogger.error("Problem (" + this.getProblemInfo().getClass().getSimpleName() + ") is not RPC but request RPC schema.");
            return;
        }
        try {
            RPCEndpointsBuilder.validateCustomizedValueInRequests(this.getCustomizedValueInRequests());
            RPCEndpointsBuilder.validateCustomizedNotNullAnnotationForRPCDto(this.specifyCustomizedNotNullAnnotation());
            RPCProblem rpcp = (RPCProblem)this.getProblemInfo();
            for (String interfaceName : rpcp.getMapOfInterfaceAndClient()) {
                InterfaceSchema schema = RPCEndpointsBuilder.build(interfaceName, rpcp.getType(), rpcp.getClient(interfaceName), rpcp.skipEndpointsByName != null ? rpcp.skipEndpointsByName.get(interfaceName) : null, rpcp.skipEndpointsByAnnotation != null ? rpcp.skipEndpointsByAnnotation.get(interfaceName) : null, rpcp.involveEndpointsByName != null ? rpcp.involveEndpointsByName.get(interfaceName) : null, rpcp.involveEndpointsByAnnotation != null ? rpcp.involveEndpointsByAnnotation.get(interfaceName) : null, this.getInfoForAuthentication(), this.getCustomizedValueInRequests(), this.specifyCustomizedNotNullAnnotation());
                this.rpcInterfaceSchema.put(interfaceName, schema);
            }
            this.localAuthSetupSchemaMap.clear();
            Map<Integer, LocalAuthSetupSchema> local = RPCEndpointsBuilder.buildLocalAuthSetup(this.getInfoForAuthentication());
            if (local != null && !local.isEmpty()) {
                this.localAuthSetupSchemaMap.putAll(local);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract the RPC Schema: " + e.getMessage());
        }
    }

    public List<List<RPCActionDto>> handleSeededTests() {
        if (this.seedRPCTests() == null || this.seedRPCTests().isEmpty()) {
            return null;
        }
        if (this.rpcInterfaceSchema.isEmpty()) {
            throw new IllegalStateException("empty RPC interface: The RPC interface schemas are not extracted yet");
        }
        ArrayList<List<RPCActionDto>> results = new ArrayList<List<RPCActionDto>>();
        for (SeededRPCTestDto dto : this.seedRPCTests()) {
            if (dto.rpcFunctions != null && !dto.rpcFunctions.isEmpty()) {
                ArrayList<RPCActionDto> test = new ArrayList<RPCActionDto>();
                for (SeededRPCActionDto actionDto : dto.rpcFunctions) {
                    InterfaceSchema schema = this.rpcInterfaceSchema.get(actionDto.interfaceName);
                    if (schema != null) {
                        EndpointSchema actionSchema = schema.getOneEndpointWithSeededDto(actionDto);
                        if (actionSchema != null) {
                            EndpointSchema copy = actionSchema.copyStructure();
                            for (int i = 0; i < copy.getRequestParams().size(); ++i) {
                                NamedTypedValue p = copy.getRequestParams().get(i);
                                try {
                                    String stringValue = actionDto.inputParams.get(i);
                                    p.setValueBasedOnInstanceOrJson(stringValue);
                                    continue;
                                }
                                catch (JsonProcessingException e) {
                                    throw new IllegalStateException(String.format("Seeded Test Error: cannot parse the seeded test %s at the parameter %d with error msg: %s", actionDto, i, e.getMessage()));
                                }
                            }
                            test.add(copy.getDto());
                            continue;
                        }
                        throw new IllegalStateException("Seeded Test Error: cannot find the action " + actionDto.functionName);
                    }
                    throw new IllegalStateException("Seeded Test Error: cannot find the interface " + actionDto.interfaceName);
                }
                results.add(test);
                continue;
            }
            SimpleLogger.warn("Seeded Test: empty RPC function calls for the test " + dto.testName);
        }
        return results;
    }

    @Deprecated
    public final boolean verifySqlConnection() {
        return true;
    }

    public abstract void newSearch();

    public final void newTest() {
        this.actionIndex = -1;
        this.resetExtraHeuristics();
        this.extras.clear();
        this.accessedTables.clear();
        this.newTestSpecificHandler();
        this.setExecutingAction(false);
    }

    public final void newAction(ActionDto dto) {
        if (dto.index > this.extras.size()) {
            this.extras.add(this.computeExtraHeuristics());
        }
        this.actionIndex = dto.index;
        this.resetExtraHeuristics();
        this.newActionSpecificHandler(dto);
    }

    public final void executeHandleLocalAuthenticationSetup(RPCActionDto dto, ActionResponseDto responseDto) {
        LocalAuthSetupSchema endpointSchema = new LocalAuthSetupSchema();
        endpointSchema.setValue(dto);
        this.handleLocalAuthenticationSetup(endpointSchema.getAuthenticationInfo());
        if (dto.responseVariable != null && dto.doGenerateTestScript) {
            responseDto.testScript = endpointSchema.newInvocationWithJava(dto.responseVariable, dto.controllerVariable, dto.clientVariable);
        }
    }

    public final void executeAction(RPCActionDto dto, ActionResponseDto responseDto) {
        Object response;
        EndpointSchema endpointSchema = this.getEndpointSchema(dto);
        if (dto.responseVariable != null && dto.doGenerateTestScript) {
            try {
                responseDto.testScript = endpointSchema.newInvocationWithJava(dto.responseVariable, dto.controllerVariable, dto.clientVariable);
            }
            catch (Exception e) {
                SimpleLogger.warn("Fail to generate test script" + e.getMessage());
            }
            if (responseDto.testScript == null) {
                SimpleLogger.warn("Null test script for action " + dto.actionName);
            }
        }
        try {
            response = this.executeRPCEndpoint(dto, false);
        }
        catch (Exception e) {
            throw new RuntimeException("ERROR: target exception should be caught, but " + e.getMessage());
        }
        if (response instanceof Exception) {
            try {
                RPCExceptionHandler.handle(response, responseDto, endpointSchema, this.getRPCType(dto));
                return;
            }
            catch (Exception e) {
                SimpleLogger.error("ERROR: fail to handle exception instance to dto " + e.getMessage());
            }
        }
        if (endpointSchema.getResponse() != null && response != null) {
            try {
                NamedTypedValue resSchema = endpointSchema.getResponse().copyStructureWithProperties();
                resSchema.setValueBasedOnInstance(response);
                responseDto.rpcResponse = resSchema.getDto();
                if (dto.doGenerateAssertions && dto.responseVariable != null) {
                    responseDto.assertionScript = resSchema.newAssertionWithJava(dto.responseVariable, dto.maxAssertionForDataInCollection);
                } else {
                    responseDto.jsonResponse = this.objectMapper.writeValueAsString(response);
                }
            }
            catch (Exception e) {
                SimpleLogger.error("ERROR: fail to set successful response instance value to dto " + e.getMessage());
            }
            try {
                responseDto.customizedCallResultCode = this.categorizeBasedOnResponse(response);
            }
            catch (Exception e) {
                SimpleLogger.error("ERROR: fail to categorize result with implemented categorizeBasedOnResponse " + e.getMessage());
            }
        }
    }

    private Object executeRPCEndpoint(RPCActionDto dto, boolean throwTargetException) throws Exception {
        Object client = ((RPCProblem)this.getProblemInfo()).getClient(dto.interfaceId);
        EndpointSchema endpointSchema = this.getEndpointSchema(dto);
        return this.executeRPCEndpointCatchTargetException(client, endpointSchema, throwTargetException);
    }

    private Object executeRPCEndpointCatchTargetException(Object client, EndpointSchema endpoint, boolean throwTargetException) throws Exception {
        Object res;
        try {
            res = this.executeRPCEndpoint(client, endpoint);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("EM RPC REQUEST EXECUTION ERROR: fail to process a RPC request with " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            if (throwTargetException) {
                throw (Exception)e.getTargetException();
            }
            res = e.getTargetException();
        }
        catch (Exception e) {
            SimpleLogger.error("ERROR: other exception exists " + e.getMessage());
            if (throwTargetException) {
                throw e;
            }
            res = e;
        }
        return res;
    }

    @Override
    public Object executeRPCEndpoint(String json) throws Exception {
        try {
            RPCActionDto dto = this.objectMapper.readValue(json, RPCActionDto.class);
            return this.executeRPCEndpoint(dto, true);
        }
        catch (JsonProcessingException e) {
            SimpleLogger.error("Failed to extract the json: " + e.getMessage());
            return null;
        }
    }

    private final Object executeRPCEndpoint(Object client, EndpointSchema endpoint) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        if (endpoint.getRequestParams().isEmpty()) {
            Method method = client.getClass().getDeclaredMethod(endpoint.getName(), new Class[0]);
            return method.invoke(client, new Object[0]);
        }
        Object[] params = new Object[endpoint.getRequestParams().size()];
        Class[] types = new Class[endpoint.getRequestParams().size()];
        try {
            for (int i = 0; i < params.length; ++i) {
                NamedTypedValue param = endpoint.getRequestParams().get(i);
                params[i] = param.newInstance();
                types[i] = ((TypeSchema)param.getType()).getClazz();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("ERROR: fail to instance value of input parameters based on dto/schema, msg error:" + e.getMessage());
        }
        Method method = client.getClass().getDeclaredMethod(endpoint.getName(), types);
        return method.invoke(client, params);
    }

    private EndpointSchema getEndpointSchema(RPCActionDto dto) {
        InterfaceSchema interfaceSchema = this.rpcInterfaceSchema.get(dto.interfaceId);
        EndpointSchema endpointSchema = interfaceSchema.getOneEndpoint(dto).copyStructure();
        endpointSchema.setValue(dto);
        return endpointSchema;
    }

    private RPCType getRPCType(RPCActionDto dto) {
        return this.rpcInterfaceSchema.get(dto.interfaceId).getRpcType();
    }

    public abstract void newTestSpecificHandler();

    public abstract void newActionSpecificHandler(ActionDto var1);

    public abstract boolean isInstrumentationActivated();

    public abstract boolean isSutRunning();

    public abstract String getPackagePrefixesToCover();

    public abstract List<AuthenticationDto> getInfoForAuthentication();

    @Deprecated
    public final Connection getConnection() {
        throw new IllegalStateException("This deprecated method should never be called");
    }

    @Deprecated
    public final String getDatabaseDriverName() {
        throw new IllegalStateException("This deprecated method should never be called");
    }

    public abstract List<TargetInfo> getTargetInfos(Collection<Integer> var1);

    public abstract List<AdditionalInfo> getAdditionalInfoList();

    public abstract ProblemInfo getProblemInfo();

    public abstract SutInfoDto.OutputFormat getPreferredOutputFormat();

    public abstract UnitsInfoDto getUnitsInfoDto();

    public abstract void setKillSwitch(boolean var1);

    public abstract void setExecutingInitSql(boolean var1);

    public abstract void setExecutingAction(boolean var1);

    public abstract BootTimeInfoDto getBootTimeInfoDto();

    protected BootTimeInfoDto getBootTimeInfoDto(BootTimeObjectiveInfo info) {
        if (info == null) {
            return null;
        }
        BootTimeInfoDto infoDto = new BootTimeInfoDto();
        infoDto.targets = info.getObjectiveCoverageAtSutBootTime().entrySet().stream().map(e -> new TargetInfoDto((Map.Entry)e){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
                this.descriptiveId = (String)this.val$e.getKey();
                this.value = (Double)this.val$e.getValue();
            }
        }).collect(Collectors.toList());
        infoDto.externalServicesDto = info.getExternalServiceInfo().stream().map(e -> new ExternalServiceInfoDto(e.getProtocol(), e.getHostname(), e.getRemotePort())).collect(Collectors.toList());
        return infoDto;
    }

    public abstract String getExecutableFullPath();

    protected UnitsInfoDto getUnitsInfoDto(UnitsInfoRecorder recorder) {
        if (recorder == null) {
            return null;
        }
        UnitsInfoDto dto = new UnitsInfoDto();
        dto.numberOfBranches = recorder.getNumberOfBranches();
        dto.numberOfLines = recorder.getNumberOfLines();
        dto.numberOfReplacedMethodsInSut = recorder.getNumberOfReplacedMethodsInSut();
        dto.numberOfReplacedMethodsInThirdParty = recorder.getNumberOfReplacedMethodsInThirdParty();
        dto.numberOfTrackedMethods = recorder.getNumberOfTrackedMethods();
        dto.unitNames = recorder.getUnitNames();
        dto.parsedDtos = recorder.getParsedDtos();
        dto.numberOfInstrumentedNumberComparisons = recorder.getNumberOfInstrumentedNumberComparisons();
        return dto;
    }

    @Override
    public Object getRPCClient(String interfaceName) {
        if (!(this.getProblemInfo() instanceof RPCProblem)) {
            throw new RuntimeException("ERROR: the problem should be RPC but it is " + this.getProblemInfo().getClass().getSimpleName());
        }
        Object client = ((RPCProblem)this.getProblemInfo()).getClient(interfaceName);
        if (client == null) {
            throw new RuntimeException("ERROR: cannot find any client with the name :" + interfaceName);
        }
        return client;
    }

    @Override
    public CustomizedCallResultCode categorizeBasedOnResponse(Object response) {
        return null;
    }

    @Override
    public List<CustomizedRequestValueDto> getCustomizedValueInRequests() {
        return null;
    }

    @Override
    public List<CustomizedNotNullAnnotationForRPCDto> specifyCustomizedNotNullAnnotation() {
        return null;
    }

    @Override
    public List<SeededRPCTestDto> seedRPCTests() {
        return null;
    }

    @Override
    public void resetDatabase(List<String> tablesToClean) {
        if (this.getDbSpecifications() != null && !this.getDbSpecifications().isEmpty()) {
            this.getDbSpecifications().forEach(spec -> {
                if (spec == null || spec.connection == null || !spec.employSmartDbClean) {
                    return;
                }
                if (spec.schemaNames == null || spec.schemaNames.isEmpty()) {
                    DbCleaner.clearDatabase(spec.connection, null, null, tablesToClean, spec.dbType);
                } else {
                    spec.schemaNames.forEach(sp -> DbCleaner.clearDatabase(spec.connection, sp, null, tablesToClean, spec.dbType));
                }
                try {
                    this.handleInitSql((Collection<String>)tablesToClean, (DbSpecification)spec);
                }
                catch (SQLException e) {
                    throw new RuntimeException("Fail to execute the specified initSqlScript " + e);
                }
            });
        }
    }
}

