/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.evomaster.client.java.controller.problem.rpc.AssertionsUtil;

public class CodeJavaGenerator {
    private static final String NULL_EXP = "null";
    private static final String GET_CLIENT_METHOD = "getRPCClient";

    public static String handleClassNameWithGeneric(String fullName, List<String> genericTypes) {
        if (genericTypes == null || genericTypes.isEmpty()) {
            return fullName;
        }
        return String.format("%s<%s>", fullName, String.join((CharSequence)", ", genericTypes));
    }

    public static String handleEscapeCharInString(String orgValue) {
        StringBuilder sb = new StringBuilder();
        block10: for (char c : orgValue.toCharArray()) {
            switch (c) {
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block10;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String enumValue(String enumTypeName, String itemName) {
        return String.format("%s.%s", CodeJavaGenerator.handleNestedSymbolInTypeName(enumTypeName), itemName);
    }

    public static String oneLineInstance(boolean isDeclaration, boolean doesIncludeName, String fullName, String varName, String value) {
        return CodeJavaGenerator.oneLineInstance(isDeclaration, doesIncludeName, fullName, varName, value, false);
    }

    public static String oneLineInstance(boolean isDeclaration, boolean doesIncludeName, String fullName, String varName, String value, Boolean isPrimitive) {
        StringBuilder sb = new StringBuilder();
        if (isDeclaration) {
            sb.append(CodeJavaGenerator.handleNestedSymbolInTypeName(fullName)).append(" ");
        }
        if (doesIncludeName) {
            sb.append(varName);
            if (value != null || !isPrimitive.booleanValue()) {
                sb.append(" = ");
            }
        }
        String stringValue = NULL_EXP;
        if (isPrimitive.booleanValue()) {
            stringValue = "";
        }
        if (value != null) {
            stringValue = value;
        }
        sb.append(stringValue).append(";");
        return sb.toString();
    }

    public static String oneLineSetterInstance(String setterMethodName, String fullName, String varName, String value) {
        String stringValue = NULL_EXP;
        if (value != null) {
            stringValue = CodeJavaGenerator.castToType(fullName, value);
        }
        return String.format("%s.%s(%s);", varName, setterMethodName, stringValue);
    }

    public static String setInstanceObject(String fullName, String varName) {
        return String.format("%s = %s;", varName, CodeJavaGenerator.newObject(fullName));
    }

    public static String setInstance(String varName, String instance) {
        return String.format("%s = %s;", varName, instance);
    }

    public static String setInstance(boolean includeVarName, String varName, String instance) {
        if (includeVarName) {
            return String.format("%s = %s;", varName, instance);
        }
        return instance + CodeJavaGenerator.appendLast();
    }

    public static String newObject(String fullName) {
        return CodeJavaGenerator.newObjectConsParams(fullName, "");
    }

    public static String newObjectConsParams(String fullName, String params) {
        return String.format("new %s(%s)", CodeJavaGenerator.handleNestedSymbolInTypeName(fullName), params);
    }

    public static String newArray(String fullName, int length) {
        return String.format("new %s[%d]", fullName, length);
    }

    public static String newSet() {
        return "new " + HashSet.class.getName() + "<>()";
    }

    public static String newMap() {
        return "new " + HashMap.class.getName() + "<>()";
    }

    public static String newList() {
        return "new " + ArrayList.class.getName() + "<>()";
    }

    public static String getIndent(int indent) {
        return String.join((CharSequence)"", Collections.nCopies(indent, " "));
    }

    public static List<String> getStringListWithIndent(List<String> codes, int indent) {
        codes.replaceAll(s -> CodeJavaGenerator.getIndent(indent) + s);
        return codes;
    }

    public static List<String> addCode(List<String> codes, String code, int indent) {
        codes.add(CodeJavaGenerator.getIndent(indent) + code);
        return codes;
    }

    public static List<String> addComment(List<String> codes, String comment, int indent) {
        codes.add(CodeJavaGenerator.getIndent(indent) + "// " + comment);
        return codes;
    }

    public static String castToType(String typeName, String objCode) {
        if (typeName == null) {
            return objCode;
        }
        return String.format("((%s)(%s))", CodeJavaGenerator.handleNestedSymbolInTypeName(typeName), objCode);
    }

    private static String handleNestedSymbolInTypeName(String typeName) {
        return typeName.replaceAll("\\$", "\\.");
    }

    public static String getGetClientMethod(String controllerVarName, String interfaceName) {
        return String.format("%s(%s)", controllerVarName + "." + GET_CLIENT_METHOD, interfaceName);
    }

    public static String methodInvocation(String obj, String methodName, String params) {
        if (obj == null) {
            return String.format("%s(%s)", methodName, params);
        }
        return String.format("%s.%s(%s)", obj, methodName, params);
    }

    public static String appendLast() {
        return ";";
    }

    public static String junitAssertEquals(String expectedValue, String variableName) {
        String assertionScript = String.format("assertEquals(%s, %s)", expectedValue, variableName) + CodeJavaGenerator.appendLast();
        if (AssertionsUtil.getAssertionsWithComment(assertionScript)) {
            return "//" + assertionScript;
        }
        return assertionScript;
    }

    public static String junitAssertNull(String variableName) {
        String assertionScript = String.format("assertNull(%s)", variableName) + CodeJavaGenerator.appendLast();
        if (AssertionsUtil.getAssertionsWithComment(assertionScript)) {
            return "//" + assertionScript;
        }
        return assertionScript;
    }

    public static String withSize(String variableName) {
        return String.format("%s.size()", variableName);
    }

    public static String withLength(String variableName) {
        return String.format("%s.length", variableName);
    }

    public static String junitAssertNumbersMatch(String expectedValue, String variableName) {
        String assertionScript = String.format("assertTrue(numbersMatch(%s, %s))", expectedValue, variableName) + CodeJavaGenerator.appendLast();
        if (AssertionsUtil.getAssertionsWithComment(assertionScript)) {
            return "//" + assertionScript;
        }
        return assertionScript;
    }

    public static String handleVariableName(String original) {
        return original.replaceAll("\\.", "_");
    }

    public static List<Integer> randomNInt(int max, int n) {
        if (n >= max) {
            throw new IllegalStateException("count should be less than max");
        }
        List candidates = IntStream.range(0, max).boxed().collect(Collectors.toList());
        Collections.shuffle(candidates);
        return candidates.subList(0, n);
    }
}

