/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.util.ArrayList;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;

public class FloatParam
extends PrimitiveOrWrapperParam<Float> {
    public FloatParam(String name, String type, String fullTypeName, Class<?> clazz, AccessibleSchema accessibleSchema) {
        super(name, type, fullTypeName, clazz, accessibleSchema);
    }

    public FloatParam(String name, PrimitiveOrWrapperType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public String getValueAsJavaString() {
        if (this.getValue() == null) {
            return null;
        }
        return "" + this.getValue() + "f";
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        dto.type.type = ((PrimitiveOrWrapperType)this.getType()).isWrapper ? RPCSupportedDataType.FLOAT : RPCSupportedDataType.P_FLOAT;
        if (this.getValue() != null) {
            dto.stringValue = ((Float)this.getValue()).toString();
        }
        return dto;
    }

    public FloatParam copyStructure() {
        return new FloatParam(this.getName(), (PrimitiveOrWrapperType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnStringValue(String stringValue) {
        try {
            if (stringValue != null) {
                this.setValue(Float.valueOf(Float.parseFloat(stringValue)));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: fail to convert " + stringValue + " as float value");
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((Float)instance);
    }

    @Override
    public boolean isValidInstance(Object instance) {
        return instance instanceof Float;
    }

    @Override
    public List<String> newAssertionWithJava(int indent, String responseVarName, int maxAssertionForDataInCollection) {
        if (this.getValue() == null) {
            return super.newAssertionWithJava(indent, responseVarName, maxAssertionForDataInCollection);
        }
        ArrayList<String> codes = new ArrayList<String>();
        if (((Float)this.getValue()).isInfinite() || ((Float)this.getValue()).isNaN()) {
            CodeJavaGenerator.addComment(codes, "// " + responseVarName + " is " + this.getValueAsJavaString(), indent);
        } else {
            CodeJavaGenerator.addCode(codes, CodeJavaGenerator.junitAssertNumbersMatch(this.getValueAsJavaString(), responseVarName), indent);
        }
        return codes;
    }

    @Override
    public String getPrimitiveValue(String responseVarName) {
        if (((PrimitiveOrWrapperType)this.getType()).isWrapper) {
            return responseVarName + ".floatValue()";
        }
        return responseVarName;
    }
}

