/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.CollectionParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.CollectionType;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class ListParam
extends CollectionParam<List<NamedTypedValue>> {
    public ListParam(String name, CollectionType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        if (this.getValue() == null) {
            return null;
        }
        return ((List)this.getValue()).stream().map(v -> {
            try {
                return v.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("ArrayParam: could not create new instance for value:" + v.getType());
            }
        }).collect(Collectors.toList());
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        dto.type.type = RPCSupportedDataType.LIST;
        if (this.getValue() != null) {
            dto.innerContent = ((List)this.getValue()).stream().map(s -> s.getDto()).collect(Collectors.toList());
        }
        return dto;
    }

    public ListParam copyStructure() {
        return new ListParam(this.getName(), (CollectionType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.innerContent != null && !dto.innerContent.isEmpty()) {
            NamedTypedValue t = ((CollectionType)this.getType()).getTemplate();
            List values = dto.innerContent.stream().map(s -> {
                NamedTypedValue v = t.copyStructureWithProperties();
                v.setValueBasedOnDto((ParamDto)s);
                return v;
            }).collect(Collectors.toList());
            this.setValue(values);
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        NamedTypedValue t = ((CollectionType)this.getType()).getTemplate();
        ArrayList values = new ArrayList();
        for (Object e : (List)instance) {
            NamedTypedValue copy = t.copyStructureWithProperties();
            copy.setValueBasedOnInstance(e);
            values.add(copy);
        }
        this.setValue(values);
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        NamedTypedValue t = ((CollectionType)this.getType()).getTemplate();
        ArrayList values = new ArrayList();
        if (json instanceof String) {
            Object instance = this.parseValueWithJson((String)json);
            for (Object e : (List)instance) {
                NamedTypedValue copy = t.copyStructureWithProperties();
                copy.setValueBasedOnInstanceOrJson(e);
                values.add(copy);
            }
            this.setValue(values);
        } else if (this.isValidInstance(json)) {
            this.setValueBasedOnValidInstance(json);
        } else {
            throw new RuntimeException("cannot parse List param " + this.getName() + " with the type " + json.getClass().getName());
        }
    }

    @Override
    public List<String> newInstanceWithJava(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent) {
        String fullName = ((CollectionType)this.getType()).getTypeNameForInstance();
        ArrayList<String> codes = new ArrayList<String>();
        String var = CodeJavaGenerator.oneLineInstance(isDeclaration, doesIncludeName, fullName, variableName, null);
        CodeJavaGenerator.addCode(codes, var, indent);
        if (this.getValue() == null) {
            return codes;
        }
        CodeJavaGenerator.addCode(codes, "{", indent);
        CodeJavaGenerator.addCode(codes, CodeJavaGenerator.setInstance(variableName, CodeJavaGenerator.newList()), indent + 1);
        int index = 0;
        for (NamedTypedValue e : (List)this.getValue()) {
            String eVarName = CodeJavaGenerator.handleVariableName(variableName + "_e_" + index);
            codes.addAll(e.newInstanceWithJava(true, true, eVarName, indent + 1));
            CodeJavaGenerator.addCode(codes, variableName + ".add(" + eVarName + ");", indent + 1);
            ++index;
        }
        CodeJavaGenerator.addCode(codes, "}", indent);
        return codes;
    }

    @Override
    public List<String> newAssertionWithJava(int indent, String responseVarName, int maxAssertionForDataInCollection) {
        ArrayList<String> codes = new ArrayList<String>();
        if (this.getValue() == null) {
            CodeJavaGenerator.addCode(codes, CodeJavaGenerator.junitAssertNull(responseVarName), indent);
            return codes;
        }
        CodeJavaGenerator.addCode(codes, CodeJavaGenerator.junitAssertEquals("" + ((List)this.getValue()).size(), CodeJavaGenerator.withSize(responseVarName)), indent);
        if (maxAssertionForDataInCollection == 0) {
            return codes;
        }
        List<Object> nvalue = null;
        nvalue = maxAssertionForDataInCollection > 0 && ((List)this.getValue()).size() > maxAssertionForDataInCollection ? CodeJavaGenerator.randomNInt(((List)this.getValue()).size(), maxAssertionForDataInCollection) : IntStream.range(0, ((List)this.getValue()).size()).boxed().collect(Collectors.toList());
        Iterator iterator = nvalue.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            NamedTypedValue e = (NamedTypedValue)((List)this.getValue()).get(index);
            String eVar = responseVarName + ".get(" + index + ")";
            codes.addAll(e.newAssertionWithJava(indent, eVar, maxAssertionForDataInCollection));
        }
        return codes;
    }

    @Override
    public String getValueAsJavaString() {
        return null;
    }
}

