/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.evomaster.client.java.instrumentation.ClassesToExclude;
import org.evomaster.client.java.instrumentation.Instrumentator;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.org.objectweb.asm.ClassReader;

public class InstrumentingClassLoader
extends ClassLoader {
    private final Instrumentator instrumentator;
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> classes;
    private boolean crashWhenFailedInstrumentation = false;

    public InstrumentingClassLoader(String packagePrefixesToCover) throws IllegalArgumentException {
        this.instrumentator = new Instrumentator(packagePrefixesToCover);
        this.classLoader = InstrumentingClassLoader.class.getClassLoader();
        this.classes = new LinkedHashMap();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!ClassesToExclude.checkIfCanInstrument(ClassName.get(name))) {
            return this.loadNonInstrumented(name);
        }
        Class<?> result = this.classes.get(name);
        if (result != null) {
            return result;
        }
        ClassName className = new ClassName(name);
        Class<?> instrumentedClass = this.instrumentClass(className);
        if (instrumentedClass == null) {
            return this.loadNonInstrumented(name);
        }
        return instrumentedClass;
    }

    private Class<?> loadNonInstrumented(String name) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result != null) {
            return result;
        }
        result = this.classLoader.loadClass(name);
        return result;
    }

    public boolean isCrashWhenFailedInstrumentation() {
        return this.crashWhenFailedInstrumentation;
    }

    public void setCrashWhenFailedInstrumentation(boolean crashWhenFailedInstrumentation) {
        this.crashWhenFailedInstrumentation = crashWhenFailedInstrumentation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> instrumentClass(ClassName className) throws ClassNotFoundException {
        try (InputStream is = this.classLoader.getResourceAsStream(className.getAsResourcePath());){
            if (is == null) {
                SimpleLogger.warn("Failed to find resource file for " + className.getAsResourcePath());
                Class<?> clazz2 = null;
                return clazz2;
            }
            byte[] byteBuffer = this.instrumentator.transformBytes(this, className, new ClassReader(is));
            this.createPackageDefinition(className.getFullNameWithDots());
            Class<?> result = this.defineClass(className.getFullNameWithDots(), byteBuffer, 0, byteBuffer.length);
            this.classes.put(className.getFullNameWithDots(), result);
            SimpleLogger.debug("Loaded class: " + className.getFullNameWithDots());
            Class<?> clazz = result;
            return clazz;
        }
        catch (Throwable t) {
            SimpleLogger.error("Error while loading class " + className.getFullNameWithDots(), t);
            if (!this.crashWhenFailedInstrumentation) return null;
            throw new RuntimeException(t);
        }
    }

    private void createPackageDefinition(String className) {
        String pkgname;
        Package pkg;
        int i = className.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgname = className.substring(0, i))) == null) {
            this.definePackage(pkgname, null, null, null, null, null, null, null);
        }
    }
}

